/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {ClayIconSpriteContext} from '@clayui/icon';
import {DragLayer} from 'data-engine-taglib';
import React from 'react';
import {DndProvider} from 'react-dnd';
import {HTML5Backend} from 'react-dnd-html5-backend';

import {MAPPED_EVENT_TYPES} from '../../core/actions/eventTypes.es';
import Pages from '../../core/components/Pages.es';
import {INITIAL_CONFIG_STATE} from '../../core/config/initialConfigState.es';
import {INITIAL_STATE} from '../../core/config/initialState.es';
import {ConfigProvider} from '../../core/hooks/useConfig.es';
import {FormNoopProvider} from '../../core/hooks/useForm.es';
import {getConnectedReactComponentAdapter} from '../../util/ReactComponentAdapter.es';
import {parseProps} from '../../util/parseProps.es';

/**
 * Render a form just for preview without actions/reducer just with FormNoopProvider,
 * this component is for compatibility with the FormBuilder in Metal.js.
 */
const LegacyFormBuilder = React.forwardRef(
	({instance, spritemap, ...otherProps}, ref) => {
		const {config, state} = parseProps({spritemap, ...otherProps});

		return (
			<ClayIconSpriteContext.Provider value={spritemap}>
				<DndProvider backend={HTML5Backend} context={window}>
					<ConfigProvider
						config={config}
						initialConfig={INITIAL_CONFIG_STATE}
					>
						<FormNoopProvider
							initialState={INITIAL_STATE}
							onAction={({payload, type}) =>
								instance?.context.dispatch(
									MAPPED_EVENT_TYPES[type] ?? type,
									payload
								)
							}
							value={state}
						>
							<DragLayer />
							<Pages {...state} ref={ref} />
						</FormNoopProvider>
					</ConfigProvider>
				</DndProvider>
			</ClayIconSpriteContext.Provider>
		);
	}
);

LegacyFormBuilder.displayName = 'LegacyFormBuilder';

export default getConnectedReactComponentAdapter(LegacyFormBuilder);
