/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import ClayButton from '@clayui/button';
import {RulesSupport} from 'dynamic-data-mapping-form-builder';
import React from 'react';

export default function fieldDelete({action, modalDispatch, onClose, rules}) {
	return (dispatch) => {
		if (
			!RulesSupport.findRuleByFieldName(
				action.payload.fieldName,
				null,
				rules
			)
		) {
			dispatch(action);

			return;
		}

		modalDispatch({
			payload: {
				body: Liferay.Language.get('a-rule-is-applied-to-this-field'),
				footer: [
					null,
					null,
					<ClayButton.Group key={3} spaced>
						<ClayButton displayType="secondary" onClick={onClose}>
							{Liferay.Language.get('cancel')}
						</ClayButton>
						<ClayButton
							displayType="danger"
							onClick={() => {
								onClose();
								dispatch(action);
							}}
						>
							{Liferay.Language.get('confirm')}
						</ClayButton>
					</ClayButton.Group>,
				],
				header: Liferay.Language.get('delete-field-with-rule-applied'),
				size: 'md',
			},
			type: 1,
		});
	};
}
