/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {makeFetch} from 'dynamic-data-mapping-form-renderer';

export function elementSetAdded({
	definitionURL,
	editingLanguageId,
	elementSetId,
	indexes,
	namespace,
}) {
	return async (dispatch) => {
		const {pages} = await makeFetch({
			method: 'GET',
			url: `${definitionURL}?ddmStructureId=${elementSetId}&languageId=${editingLanguageId}&portletNamespace=${namespace}`,
		});

		dispatch({
			payload: {
				elementSetPages: pages,
				indexes,
			},
			type: 'element_set_add',
		});
	};
}
