/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

const SYMBOL_CONTEXT = Symbol('schema.context');

const SYMBOL_TYPE = Symbol('schema.type');

export const SYMBOL_CACHE = Symbol('schema.cache');

export const SYMBOL_RAW = Symbol('schema.raw');

export class Schema {
	constructor(context, type, raw) {
		this[SYMBOL_CONTEXT] = context;
		this[SYMBOL_TYPE] = type;
		this[SYMBOL_RAW] = raw;
		this[SYMBOL_CACHE] = {};
	}
}
