/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {SYMBOL_RAW, Schema} from './Schema.es';

export class DataLayoutRowSchema extends Schema {
	constructor(raw) {
		super('data_engine', 'dataLayoutRow', raw);
	}

	get dataLayoutColumns() {
		return this[SYMBOL_RAW].columns.map((column) => ({
			columnSize: column.size,
			fieldNames: column.fields.map(({fieldName}) => fieldName),
		}));
	}
}

export class DataLayoutPageSchema extends Schema {
	constructor(raw) {
		super('data_engine', 'dataLayoutPage', raw);
	}

	get dataLayoutRows() {
		return this[SYMBOL_RAW].rows.map((row) => new DataLayoutRowSchema(row));
	}

	get description() {
		return this[SYMBOL_RAW].localizedDescription;
	}

	get title() {
		return this[SYMBOL_RAW].localizedTitle;
	}
}

export class DataLayoutSchema extends Schema {
	static props = ['dataLayout', 'name', 'pages', 'rules'];

	constructor(raw) {
		super('data_engine', 'dataLayout', raw);
	}

	get dataRules() {
		return this[SYMBOL_RAW].rules.map((rule) => ({
			...rule,
			name: {
				en_US: rule.name,
			},
		}));
	}

	get dataLayoutFields() {
		return this[SYMBOL_RAW].dataLayout.dataLayoutFields;
	}

	get dataLayoutPages() {
		return this[SYMBOL_RAW].pages.map(
			(page) => new DataLayoutPageSchema(page)
		);
	}

	get name() {
		return this[SYMBOL_RAW].name;
	}
}
