/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {DataConverter} from 'data-engine-taglib';
import {PagesVisitor} from 'dynamic-data-mapping-form-renderer';

import {SYMBOL_CACHE, SYMBOL_RAW, Schema} from './Schema.es';

export class DataDefinitionSchema extends Schema {
	static props = [
		'availableLanguageIds',
		'dataDefinition',
		'defaultLanguageId',
		'name',
		'pages',
	];

	constructor(raw) {
		super('data_engine', 'dataDefinition', raw);
	}

	get availableLanguageIds() {
		return this[SYMBOL_RAW].availableLanguageIds;
	}

	get contentType() {
		return this[SYMBOL_RAW].dataDefinition.contentType;
	}

	get dataDefinitionFields() {
		const {dataDefinition, pages} = this[SYMBOL_RAW];

		// This operation will happen only once and the next calls are from the cache,
		// the value will be revalidated by Schema that makes a comparison by reference
		// of the Schema's props with the state, any changes in these properties the
		// Schema is recreated.

		if (this[SYMBOL_CACHE].dataDefinitionFields) {
			return this[SYMBOL_CACHE].dataDefinitionFields;
		}
		else {
			const fields = [...dataDefinition.dataDefinitionFields];
			const visitor = new PagesVisitor(pages);

			visitor.mapFields((field) => {
				const index = fields.findIndex(
					({name}) => name === field.fieldName
				);

				const newField = DataConverter.getDataDefinitionField(field);

				if (index === -1) {
					fields.push(newField);
				}
				else {
					fields[index] = newField;
				}
			});

			this[SYMBOL_CACHE].dataDefinitionFields = fields;

			return this[SYMBOL_CACHE].dataDefinitionFields;
		}
	}

	get defaultLanguageId() {
		return this[SYMBOL_RAW].defaultLanguageId;
	}

	get name() {
		return this[SYMBOL_RAW].name;
	}
}
