/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {useResource} from '@clayui/data-provider';
import {fetch} from 'frontend-js-web';

import {useStorage} from './useStorage.es';

const ENDPOINT_FIELD_TYPES = `${
	window.location.origin
}${themeDisplay.getPathContext()}/o/dynamic-data-mapping-form-field-types`;

const HEADERS = {
	Accept: 'application/json',
	'Accept-Language': Liferay.ThemeDisplay.getBCP47LanguageId(),
	'Content-Type': 'application/json',
};

export const useFieldTypesResource = () => {
	const storage = useStorage();

	return useResource({
		fetch: (url, options) => fetch(url, options).then((res) => res.json()),
		fetchOptions: {
			headers: HEADERS,
		},
		fetchPolicy: 'cache-first',
		link: ENDPOINT_FIELD_TYPES,
		storage,
		variables: {
			p_auth: Liferay.authToken,
		},
	});
};
