/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {FieldUtil} from 'dynamic-data-mapping-form-builder';

/**
 * This is a literary copy of the logic of the old LayoutProvider,
 * check the documentation for more details.
 */
const getFieldNameGenerator = (pages, generateFieldNameUsingFieldLabel) => (
	preferredName,
	currentName,
	blacklist = []
) =>
	FieldUtil.generateFieldName(
		pages,
		preferredName,
		currentName,
		blacklist,
		generateFieldNameUsingFieldLabel
	);

export const INITIAL_CONFIG_STATE = {
	cache: {},
	generateFieldNameUsingFieldLabel: false,
	getFieldNameGenerator,
};
