/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import ClayLayout from '@clayui/layout';
import classnames from 'classnames';
import React, {useContext} from 'react';

import {DND_ORIGIN_TYPE, useDrop} from '../hooks/useDrop.es';
import {ParentFieldContext} from './Field/ParentFieldContext.es';

export const Placeholder = ({
	columnIndex,
	isRow,
	pageIndex,
	rowIndex,
	size,
}) => {
	const parentField = useContext(ParentFieldContext);
	const {canDrop, drop, overTarget} = useDrop({
		columnIndex: columnIndex ?? 0,
		origin: DND_ORIGIN_TYPE.EMPTY,
		pageIndex,
		parentField,
		rowIndex,
	});

	const Content = (
		<ClayLayout.Col
			className="col col-ddm col-empty"
			data-ddm-field-column={columnIndex}
			data-ddm-field-page={pageIndex}
			data-ddm-field-row={rowIndex}
			md={size}
		>
			<div
				className={classnames('ddm-target', {
					'target-over targetOver':
						overTarget &&
						canDrop &&
						!parentField.root?.ddmStructureId,
				})}
				ref={!parentField.root?.ddmStructureId ? drop : undefined}
			/>
		</ClayLayout.Col>
	);

	if (isRow) {
		return <div className="placeholder row">{Content}</div>;
	}

	return Content;
};
