/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import './PageRenderer.soy';

import classNames from 'classnames';
import React, {useRef} from 'react';

import {useConfig} from '../hooks/useConfig.es';
import {useFormState} from '../hooks/useForm.es';
import {useFieldTypesResource} from '../hooks/useResource.es';
import {ActionsProvider} from './Actions.es';
import Page from './PageRenderer/Page.es';

function getDisplayableValue({containerId, readOnly, viewMode}) {
	return (
		readOnly || !viewMode || document.getElementById(containerId) !== null
	);
}

const Pages = React.forwardRef(
	({editable, fieldActions, ...otherProps}, ref) => {
		const {containerId, portletNamespace, view} = useConfig();
		const {
			activePage,
			displayable: initialDisplayableValue,
			editingLanguageId,
			focusedField,
			forceAriaUpdate,
			invalidFormMessage,
			pages,
			paginationMode,
			persistDefaultValues,
			readOnly,
			viewMode,
		} = useFormState();

		const {resource: fieldTypes} = useFieldTypesResource();

		const containerFallbackRef = useRef();

		const displayable =
			initialDisplayableValue ||
			getDisplayableValue({containerId, readOnly, viewMode});

		if (!displayable) {
			return null;
		}

		const containerElementRef = ref ?? containerFallbackRef;

		return (
			<div
				className={classNames({sheet: view === 'fieldSets'})}
				ref={containerElementRef}
			>
				<input
					key={portletNamespace + 'persistDefaultValues'}
					name={portletNamespace + 'persistDefaultValues'}
					type="hidden"
					value={persistDefaultValues}
				/>

				<div
					className={classNames(
						'lfr-ddm-form-container position-relative',
						{
							'ddm-user-view-content': !editable,
						}
					)}
				>
					<ActionsProvider
						actions={fieldActions}
						focusedFieldId={focusedField?.fieldName}
					>
						{pages.map((page, index) => (
							<Page
								{...otherProps}
								activePage={activePage}
								containerElement={containerElementRef}
								editable={editable}
								editingLanguageId={editingLanguageId}
								fieldTypes={fieldTypes}
								forceAriaUpdate={forceAriaUpdate}
								invalidFormMessage={invalidFormMessage}
								key={page.id}
								page={page}
								pageIndex={index}
								pages={pages}
								paginationMode={paginationMode}
								portletNamespace={portletNamespace}
								readOnly={readOnly}
								total={pages.length}
								view={view}
								viewMode={viewMode}
							/>
						))}
					</ActionsProvider>
				</div>
			</div>
		);
	}
);

Pages.displayName = 'Pages';

export default React.memo(Pages);
