/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import ClayLayout from '@clayui/layout';
import React from 'react';

import {Tabs} from '../Tabs.es';
import * as DefaultVariant from './DefaultVariant.es';

export const Column = ({children, column, index}) => {
	if (column.fields.length === 0) {
		return null;
	}

	return (
		<ClayLayout.Col key={index} md={column.size}>
			{column.fields.map((field, index) => children({field, index}))}
		</ClayLayout.Col>
	);
};

Column.displayName = 'TabbedVariant.Column';

export const Container = ({activePage, children, pageIndex, pages}) => (
	<div className="ddm-form-page-container tabbed">
		{pages.length > 0 && pageIndex === activePage && (
			<Tabs activePage={activePage} pageIndex={pageIndex} pages={pages} />
		)}

		<DefaultVariant.Container
			activePage={activePage}
			isBuilder={false}
			pageIndex={pageIndex}
		>
			{children}
		</DefaultVariant.Container>
	</div>
);

Container.displayName = 'TabbedVariant.Container';

export const Page = ({children}) => children;

Page.displayName = 'TabbedVariant.Page';

export const Rows = ({children, rows}) =>
	rows.map((row, index) => children({index, row}));

Rows.displayName = 'TabbedVariant.Rows';
