/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal.servlet;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class DDMFormTemplateContextProcessor {
    private final DDMForm _ddmForm = new DDMForm();
    private long _ddmFormInstanceId;
    private final DDMFormLayout _ddmFormLayout = new DDMFormLayout();
    private final DDMFormValues _ddmFormValues;
    private long _groupId;
    private final JSONObject _jsonObject;
    private final Locale _locale;

    public DDMFormTemplateContextProcessor(JSONObject jsonObject, String languageId) {
        this._jsonObject = jsonObject;
        this._ddmFormValues = new DDMFormValues(this._ddmForm);
        this._locale = LocaleUtil.fromLanguageId((String)languageId);
        this.initModels();
        this.process();
    }

    public DDMForm getDDMForm() {
        return this._ddmForm;
    }

    public long getDDMFormInstanceId() {
        return this._ddmFormInstanceId;
    }

    public DDMFormLayout getDDMFormLayout() {
        return this._ddmFormLayout;
    }

    public DDMFormValues getDDMFormValues() {
        return this._ddmFormValues;
    }

    public long getGroupId() {
        return this._groupId;
    }

    protected void addDDMFormDDMFormField(JSONObject jsonObject) {
        String fieldName;
        Map ddmFormFields = this._ddmForm.getDDMFormFieldsMap(true);
        if (ddmFormFields.containsKey(fieldName = jsonObject.getString("fieldName"))) {
            return;
        }
        this._ddmForm.addDDMFormField(this.getDDMFormField(jsonObject));
    }

    protected void addDDMFormValuesDDMFormFieldValue(JSONObject jsonObject) {
        this._ddmFormValues.addDDMFormFieldValue(this.getDDMFormFieldValue(jsonObject));
    }

    protected DDMFormField getDDMFormField(JSONObject jsonObject) {
        String name = jsonObject.getString("fieldName");
        String type = jsonObject.getString("type");
        DDMFormField ddmFormField = new DDMFormField(name, type);
        this.setDDMFormFieldConfirmationErrorMessage(jsonObject.getString("confirmationErrorMessage"), ddmFormField);
        this.setDDMFormFieldConfirmationLabel(jsonObject.getString("confirmationLabel"), ddmFormField);
        this.setDDMFormFieldCustomProperties(jsonObject, ddmFormField);
        this.setDDMFormFieldDataType(jsonObject.getString("dataType"), ddmFormField);
        this.setDDMFormFieldFieldName(jsonObject.getString("fieldName"), ddmFormField);
        this.setDDMFormFieldFieldReference(jsonObject.getString("fieldReference"), ddmFormField);
        this.setDDMFormFieldInputMaskFormat(jsonObject.getString("inputMaskFormat"), ddmFormField);
        this.setDDMFormFieldLabel(jsonObject.getString("label"), ddmFormField);
        this.setDDMFormFieldLayout(ddmFormField, jsonObject.getString("layout"));
        this.setDDMFormFieldLocalizable(jsonObject.getBoolean("localizable", false), ddmFormField);
        this.setDDMFormFieldMultiple(jsonObject.getBoolean("multiple"), ddmFormField);
        this.setDDMFormFieldNumericInputMask(jsonObject.getString("numericInputMask"), ddmFormField);
        this.setDDMFormFieldOptions(jsonObject.getJSONArray("options"), ddmFormField);
        this.setDDMFormFieldPredefinedValue(jsonObject.getString("predefinedValue"), ddmFormField);
        this.setDDMFormFieldPlaceholder(jsonObject.getString("placeholder"), ddmFormField);
        this.setDDMFormFieldProperty(ddmFormField, "buttonLabel", jsonObject.getString("buttonLabel"));
        this.setDDMFormFieldProperty(ddmFormField, "title", jsonObject.getString("title"));
        this.setDDMFormFieldPropertyDDMStructureId(jsonObject, ddmFormField);
        this.setDDMFormFieldPropertyDDMStructureLayoutId(jsonObject, ddmFormField);
        this.setDDMFormFieldPropertyMessage(ddmFormField, jsonObject.getString("message"));
        this.setDDMFormFieldPropertyOptions(jsonObject, ddmFormField, "columns");
        this.setDDMFormFieldPropertyRows(jsonObject, ddmFormField);
        this.setDDMFormFieldPropertyUpgradedStructure(jsonObject, ddmFormField);
        this.setDDMFormFieldReadOnly(jsonObject.getBoolean("readOnly", false), ddmFormField);
        this.setDDMFormFieldRepeatable(jsonObject.getBoolean("repeatable", false), ddmFormField);
        this.setDDMFormFieldRequired(jsonObject.getBoolean("required", false), ddmFormField);
        this.setDDMFormFieldRequiredErrorMessage(this.getLocalizedValue(jsonObject.getString("requiredErrorMessage")), ddmFormField);
        this.setDDMFormFieldText(jsonObject.getString("text"), ddmFormField);
        this.setDDMFormFieldTooltip(jsonObject.getString("tooltip"), ddmFormField);
        this.setDDMFormFieldValid(jsonObject.getBoolean("valid", true), ddmFormField);
        this.setDDMFormFieldValidation(jsonObject.getJSONObject("validation"), ddmFormField);
        this.setDDMFormFieldVisibilityExpression(jsonObject.getString("visibilityExpression"), ddmFormField);
        this.setDDMFormFieldVisibleFields(ddmFormField, jsonObject.getString("visibleFields"));
        this.setDDMFormFieldNestedFields(jsonObject.getJSONArray("nestedFields"), ddmFormField);
        return ddmFormField;
    }

    protected DDMFormFieldOptions getDDMFormFieldOptions(JSONArray jsonArray) {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String value = jsonObject.getString("value");
            ddmFormFieldOptions.addOptionLabel(value, this._locale, jsonObject.getString("label"));
            ddmFormFieldOptions.addOptionReference(value, jsonObject.getString("reference"));
        }
        return ddmFormFieldOptions;
    }

    protected DDMFormFieldValue getDDMFormFieldValue(JSONObject jsonObject) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setConfirmationValue(jsonObject.get("confirmationValue"));
        ddmFormFieldValue.setFieldReference(jsonObject.getString("fieldReference"));
        ddmFormFieldValue.setName(jsonObject.getString("fieldName"));
        ddmFormFieldValue.setInstanceId(jsonObject.getString("instanceId"));
        this.setDDMFormFieldValueValue(jsonObject.getString("value"), jsonObject.getBoolean("localizable", false), ddmFormFieldValue);
        this.setDDMFormFieldValueNestedFieldValues(jsonObject.getJSONArray("nestedFields"), ddmFormFieldValue);
        return ddmFormFieldValue;
    }

    protected DDMFormRule getDDMFormRule(JSONObject jsonObject) {
        List<String> actions = this.getDDMFormRuleActions(jsonObject.getJSONArray("actions"));
        return new DDMFormRule(actions, jsonObject.getString("condition"));
    }

    protected List<String> getDDMFormRuleActions(JSONArray jsonArray) {
        ArrayList<String> actions = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            actions.add(jsonArray.getString(i));
        }
        return actions;
    }

    protected List<DDMFormRule> getDDMFormRules(JSONArray jsonArray) {
        ArrayList<DDMFormRule> ddmFormRules = new ArrayList<DDMFormRule>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormRule ddmFormRule = this.getDDMFormRule(jsonArray.getJSONObject(i));
            ddmFormRules.add(ddmFormRule);
        }
        return ddmFormRules;
    }

    protected LocalizedValue getLocalizedValue(String value) {
        LocalizedValue localizedValue = new LocalizedValue(this._locale);
        localizedValue.addString(this._locale, value);
        return localizedValue;
    }

    protected void initModels() {
        this.setDDMFormDefaultLocale();
        this.setDDMFormInstanceId();
        this.setDDMFormRules();
        this.setDDMFormValuesAvailableLocales();
        this.setDDMFormValuesDefaultLocale();
        this.setGroupId();
        this.setObjectFieldsJSONArray();
    }

    protected void process() {
        this._ddmFormLayout.setNextPage(Integer.valueOf(this._jsonObject.getInt("nextPage")));
        this._ddmFormLayout.setPreviousPage(Integer.valueOf(this._jsonObject.getInt("previousPage")));
        this.traversePages(this._jsonObject.getJSONArray("pages"));
    }

    protected void setDDMFormDefaultLocale() {
        this._ddmForm.setDefaultLocale(this._locale);
    }

    protected void setDDMFormFieldConfirmationErrorMessage(String confirmationErrorMessage, DDMFormField ddmFormField) {
        ddmFormField.setProperty("confirmationErrorMessage", (Object)this.getLocalizedValue(GetterUtil.getString((String)confirmationErrorMessage)));
    }

    protected void setDDMFormFieldConfirmationLabel(String confirmationLabel, DDMFormField ddmFormField) {
        ddmFormField.setProperty("confirmationLabel", (Object)this.getLocalizedValue(GetterUtil.getString((String)confirmationLabel)));
    }

    protected void setDDMFormFieldCustomProperties(JSONObject jsonObject, DDMFormField ddmFormField) {
        Iterator iterator = jsonObject.keys();
        Map properties = ddmFormField.getProperties();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (properties.containsKey(key) || key.equals("dataSourceType")) continue;
            ddmFormField.setProperty(key, jsonObject.get(key));
        }
    }

    protected void setDDMFormFieldDataType(String dataType, DDMFormField ddmFormField) {
        ddmFormField.setDataType(GetterUtil.getString((String)dataType));
    }

    protected void setDDMFormFieldFieldName(String fieldName, DDMFormField ddmFormField) {
        ddmFormField.setName(GetterUtil.getString((String)fieldName));
    }

    protected void setDDMFormFieldFieldReference(String fieldReference, DDMFormField ddmFormField) {
        ddmFormField.setFieldReference(GetterUtil.getString((String)fieldReference));
    }

    protected void setDDMFormFieldInputMaskFormat(String inputMaskFormat, DDMFormField ddmFormField) {
        ddmFormField.setProperty("inputMaskFormat", (Object)this.getLocalizedValue(GetterUtil.getString((String)inputMaskFormat)));
    }

    protected void setDDMFormFieldLabel(String label, DDMFormField ddmFormField) {
        ddmFormField.setLabel(this.getLocalizedValue(GetterUtil.getString((String)label)));
    }

    protected void setDDMFormFieldLayout(DDMFormField ddmFormField, String layout) {
        ddmFormField.setProperty("layout", (Object)this.getLocalizedValue(GetterUtil.getString((String)layout)));
    }

    protected void setDDMFormFieldLocalizable(boolean localizable, DDMFormField ddmFormField) {
        ddmFormField.setLocalizable(localizable);
    }

    protected void setDDMFormFieldMultiple(boolean multiple, DDMFormField ddmFormField) {
        ddmFormField.setMultiple(multiple);
    }

    protected void setDDMFormFieldNestedFields(JSONArray jsonArray, DDMFormField ddmFormField) {
        if (jsonArray == null) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormField nestedDDMFormField = this.getDDMFormField(jsonArray.getJSONObject(i));
            ddmFormField.addNestedDDMFormField(nestedDDMFormField);
        }
    }

    protected void setDDMFormFieldNumericInputMask(String numericInputMask, DDMFormField ddmFormField) {
        ddmFormField.setProperty("numericInputMask", (Object)this.getLocalizedValue(GetterUtil.getString((String)numericInputMask)));
    }

    protected void setDDMFormFieldOptions(JSONArray jsonArray, DDMFormField ddmFormField) {
        if (jsonArray == null) {
            return;
        }
        ddmFormField.setDDMFormFieldOptions(this.getDDMFormFieldOptions(jsonArray));
    }

    protected void setDDMFormFieldPlaceholder(String placeholder, DDMFormField ddmFormField) {
        ddmFormField.setProperty("placeholder", (Object)this.getLocalizedValue(GetterUtil.getString((String)placeholder)));
    }

    protected void setDDMFormFieldPredefinedValue(String predefinedValue, DDMFormField ddmFormField) {
        if (Validator.isNull((String)predefinedValue)) {
            return;
        }
        ddmFormField.setProperty("predefinedValue", (Object)this.getLocalizedValue(GetterUtil.getString((String)predefinedValue)));
    }

    protected void setDDMFormFieldProperty(DDMFormField ddmFormField, String propertyName, String propertyValue) {
        if (!Objects.equals(ddmFormField.getType(), "redirect_button")) {
            return;
        }
        ddmFormField.setProperty(propertyName, (Object)new Object[]{this.getLocalizedValue(propertyValue)});
    }

    protected void setDDMFormFieldPropertyDDMStructureId(JSONObject jsonObject, DDMFormField ddmFormField) {
        if (!Objects.equals(ddmFormField.getType(), "fieldset")) {
            return;
        }
        ddmFormField.setProperty("ddmStructureId", (Object)jsonObject.getLong("ddmStructureId"));
    }

    protected void setDDMFormFieldPropertyDDMStructureLayoutId(JSONObject jsonObject, DDMFormField ddmFormField) {
        if (!Objects.equals(ddmFormField.getType(), "fieldset")) {
            return;
        }
        ddmFormField.setProperty("ddmStructureLayoutId", (Object)jsonObject.getLong("ddmStructureLayoutId"));
    }

    protected void setDDMFormFieldPropertyFieldSetRows(JSONObject jsonObject, DDMFormField ddmFormField) {
        JSONArray jsonArray = jsonObject.getJSONArray("rows");
        if (jsonArray == null) {
            return;
        }
        ddmFormField.setProperty("rows", (Object)jsonArray.toString());
    }

    protected void setDDMFormFieldPropertyMessage(DDMFormField ddmFormField, String message) {
        if (!Objects.equals(ddmFormField.getType(), "redirect_button")) {
            return;
        }
        ddmFormField.setProperty("message", (Object)message);
    }

    protected void setDDMFormFieldPropertyOptions(JSONObject jsonObject, DDMFormField ddmFormField, String property) {
        JSONArray jsonArray = jsonObject.getJSONArray(property);
        if (jsonArray == null) {
            return;
        }
        ddmFormField.setProperty(property, (Object)this.getDDMFormFieldOptions(jsonArray));
    }

    protected void setDDMFormFieldPropertyRows(JSONObject jsonObject, DDMFormField ddmFormField) {
        String type = jsonObject.getString("type");
        if (type.equals("grid")) {
            this.setDDMFormFieldPropertyOptions(jsonObject, ddmFormField, "rows");
        } else if (type.equals("fieldset")) {
            this.setDDMFormFieldPropertyFieldSetRows(jsonObject, ddmFormField);
        }
    }

    protected void setDDMFormFieldPropertyUpgradedStructure(JSONObject jsonObject, DDMFormField ddmFormField) {
        if (!Objects.equals(ddmFormField.getType(), "fieldset")) {
            return;
        }
        ddmFormField.setProperty("upgradedStructure", (Object)jsonObject.getBoolean("upgradedStructure"));
    }

    protected void setDDMFormFieldReadOnly(boolean readOnly, DDMFormField ddmFormField) {
        ddmFormField.setReadOnly(readOnly);
    }

    protected void setDDMFormFieldRepeatable(boolean repeatable, DDMFormField ddmFormField) {
        ddmFormField.setRepeatable(repeatable);
    }

    protected void setDDMFormFieldRequired(boolean required, DDMFormField ddmFormField) {
        ddmFormField.setRequired(required);
    }

    protected void setDDMFormFieldRequiredErrorMessage(LocalizedValue requiredErrorMessage, DDMFormField ddmFormField) {
        ddmFormField.setRequiredErrorMessage(requiredErrorMessage);
    }

    protected void setDDMFormFieldText(String text, DDMFormField ddmFormField) {
        ddmFormField.setProperty("text", (Object)this.getLocalizedValue(GetterUtil.getString((String)text)));
    }

    protected void setDDMFormFieldTooltip(String tooltip, DDMFormField ddmFormField) {
        ddmFormField.setProperty("tooltip", (Object)this.getLocalizedValue(GetterUtil.getString((String)tooltip)));
    }

    protected void setDDMFormFieldValid(boolean valid, DDMFormField ddmFormField) {
        ddmFormField.setProperty("valid", (Object)valid);
    }

    protected void setDDMFormFieldValidation(final JSONObject jsonObject, DDMFormField ddmFormField) {
        if (jsonObject == null || !jsonObject.has("expression")) {
            return;
        }
        DDMFormFieldValidation ddmFormFieldValidation = new DDMFormFieldValidation();
        ddmFormFieldValidation.setErrorMessageLocalizedValue(this.getLocalizedValue(jsonObject.getString("errorMessage")));
        final JSONObject expressionJSONObject = jsonObject.getJSONObject("expression");
        if (expressionJSONObject != null) {
            ddmFormFieldValidation.setDDMFormFieldValidationExpression(new DDMFormFieldValidationExpression(){
                {
                    this.setName(expressionJSONObject.getString("name"));
                    this.setValue(expressionJSONObject.getString("value"));
                }
            });
        } else {
            ddmFormFieldValidation.setDDMFormFieldValidationExpression(new DDMFormFieldValidationExpression(){
                {
                    this.setValue(jsonObject.getString("expression"));
                }
            });
        }
        ddmFormFieldValidation.setParameterLocalizedValue(this.getLocalizedValue(jsonObject.getString("parameter")));
        ddmFormField.setDDMFormFieldValidation(ddmFormFieldValidation);
    }

    protected void setDDMFormFieldValueNestedFieldValues(JSONArray jsonArray, DDMFormFieldValue ddmFormFieldValue) {
        if (jsonArray == null) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormFieldValue nestedDDMFormFieldValue = this.getDDMFormFieldValue(jsonArray.getJSONObject(i));
            ddmFormFieldValue.addNestedDDMFormFieldValue(nestedDDMFormFieldValue);
        }
    }

    protected void setDDMFormFieldValueValue(String value, boolean localizable, DDMFormFieldValue ddmFormFieldValue) {
        if (localizable) {
            ddmFormFieldValue.setValue((Value)this.getLocalizedValue(value));
        } else {
            ddmFormFieldValue.setValue((Value)new UnlocalizedValue(value));
        }
    }

    protected void setDDMFormFieldVisibilityExpression(String visibilityExpression, DDMFormField ddmFormField) {
        ddmFormField.setVisibilityExpression(GetterUtil.getString((String)visibilityExpression));
    }

    protected void setDDMFormFieldVisibleFields(DDMFormField ddmFormField, String visibleFields) {
        ddmFormField.setProperty("visibleFields", (Object)this.getLocalizedValue(GetterUtil.getString((String)visibleFields)));
    }

    protected void setDDMFormInstanceId() {
        this._ddmFormInstanceId = this._jsonObject.getLong("formId", 0L);
    }

    protected void setDDMFormRules() {
        List<DDMFormRule> ddmFormRules = this.getDDMFormRules(this._jsonObject.getJSONArray("rules"));
        this._ddmForm.setDDMFormRules(ddmFormRules);
    }

    protected void setDDMFormValuesAvailableLocales() {
        this._ddmFormValues.addAvailableLocale(this._locale);
    }

    protected void setDDMFormValuesDefaultLocale() {
        this._ddmFormValues.setDefaultLocale(this._locale);
    }

    protected void setGroupId() {
        this._groupId = this._jsonObject.getLong("groupId", 0L);
    }

    protected void setObjectFieldsJSONArray() {
        this._ddmForm.setObjectFieldsJSONArray(this._jsonObject.getJSONArray("objectFields"));
    }

    protected void traverseColumns(JSONArray jsonArray, DDMFormLayoutRow ddmFormLayoutRow) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            DDMFormLayoutColumn ddmFormLayoutColumn = new DDMFormLayoutColumn(jsonObject.getInt("size"), new String[0]);
            this.traverseFields(jsonObject.getJSONArray("fields"), ddmFormLayoutColumn);
            ddmFormLayoutRow.addDDMFormLayoutColumn(ddmFormLayoutColumn);
        }
    }

    protected void traverseFields(JSONArray jsonArray, DDMFormLayoutColumn ddmFormLayoutColumn) {
        LinkedHashSet<String> ddmFormFieldNames = new LinkedHashSet<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            this.addDDMFormDDMFormField(jsonObject);
            this.addDDMFormValuesDDMFormFieldValue(jsonObject);
            ddmFormFieldNames.add(jsonObject.getString("fieldName"));
        }
        ddmFormLayoutColumn.setDDMFormFieldNames(ListUtil.fromCollection(ddmFormFieldNames));
    }

    protected void traversePages(JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            DDMFormLayoutPage ddmFormLayoutPage = new DDMFormLayoutPage();
            ddmFormLayoutPage.setDescription(this.getLocalizedValue(jsonObject.getString("description")));
            ddmFormLayoutPage.setTitle(this.getLocalizedValue(jsonObject.getString("title")));
            this.traverseRows(jsonObject.getJSONArray("rows"), ddmFormLayoutPage);
            this._ddmFormLayout.addDDMFormLayoutPage(ddmFormLayoutPage);
        }
    }

    protected void traverseRows(JSONArray jsonArray, DDMFormLayoutPage ddmFormLayoutPage) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            DDMFormLayoutRow ddmFormLayoutRow = new DDMFormLayoutRow();
            this.traverseColumns(jsonObject.getJSONArray("columns"), ddmFormLayoutRow);
            ddmFormLayoutPage.addDDMFormLayoutRow(ddmFormLayoutRow);
        }
    }
}

