/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

/**
 * @author Marcellus Tavares
 */
public class DefaultDDMFormValuesFactory {

	public DefaultDDMFormValuesFactory(DDMForm ddmForm) {
		_ddmForm = ddmForm;
	}

	public DDMFormValues create() {
		DDMFormValues ddmFormValues = new DDMFormValues(_ddmForm);

		ddmFormValues.setAvailableLocales(_ddmForm.getAvailableLocales());
		ddmFormValues.setDefaultLocale(_ddmForm.getDefaultLocale());

		populate(ddmFormValues);

		return ddmFormValues;
	}

	public void populate(DDMFormValues ddmFormValues) {
		_populate(
			ddmFormValues::addDDMFormFieldValue, _ddmForm.getDDMFormFields(),
			ddmFormValues.getDDMFormFieldValuesMap(false));
	}

	protected DDMFormFieldValue createDefaultDDMFormFieldValue(
		DDMFormField ddmFormField) {

		DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();

		ddmFormFieldValue.setFieldReference(ddmFormField.getFieldReference());
		ddmFormFieldValue.setName(ddmFormField.getName());
		ddmFormFieldValue.setValue(createDefaultValue(ddmFormField));

		for (DDMFormField nestedDDMFormField :
				ddmFormField.getNestedDDMFormFields()) {

			ddmFormFieldValue.addNestedDDMFormFieldValue(
				createDefaultDDMFormFieldValue(nestedDDMFormField));
		}

		return ddmFormFieldValue;
	}

	protected LocalizedValue createDefaultLocalizedValue(
		String defaultValueString) {

		LocalizedValue value = new LocalizedValue(_ddmForm.getDefaultLocale());

		value.addString(_ddmForm.getDefaultLocale(), defaultValueString);

		return value;
	}

	protected Value createDefaultValue(DDMFormField ddmFormField) {
		LocalizedValue defaultValue = ddmFormField.getPredefinedValue();

		if ((defaultValue == null) ||
			MapUtil.isEmpty(defaultValue.getValues())) {

			defaultValue = Optional.ofNullable(
				(LocalizedValue)ddmFormField.getProperty("initialValue")
			).orElse(
				createDefaultLocalizedValue(StringPool.BLANK)
			);
		}

		if (ddmFormField.isLocalizable()) {
			return defaultValue;
		}

		return new UnlocalizedValue(
			GetterUtil.getString(
				defaultValue.getString(_ddmForm.getDefaultLocale())));
	}

	private void _populate(
		Consumer<DDMFormFieldValue> consumer, List<DDMFormField> ddmFormFields,
		Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap) {

		if (ddmFormFields == null) {
			return;
		}

		ddmFormFields.forEach(
			ddmFormField -> {
				List<DDMFormFieldValue> ddmFormFieldValues =
					ddmFormFieldValuesMap.get(ddmFormField.getName());

				if (ddmFormFieldValues != null) {
					ddmFormFieldValues.forEach(
						ddmFormFieldValue -> _populate(
							ddmFormFieldValue::addNestedDDMFormFieldValue,
							ddmFormField.getNestedDDMFormFields(),
							ddmFormFieldValue.
								getNestedDDMFormFieldValuesMap()));
				}
				else {
					consumer.accept(
						createDefaultDDMFormFieldValue(ddmFormField));
				}
			});
	}

	private final DDMForm _ddmForm;

}