Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.69/js/thunks/nextPage.es", ['module', 'exports', 'require', '../actions/eventTypes.es', '../util/evaluation.es', '../util/formId.es', '../util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = nextPage;

    var _eventTypes = require("../actions/eventTypes.es");

    var _evaluation = require("../util/evaluation.es");

    var _formId = require("../util/formId.es");

    var _visitors = require("../util/visitors.es");

    /**
     * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
     * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
     */
    function nextPage(_ref) {
      var activePage = _ref.activePage,
          defaultLanguageId = _ref.defaultLanguageId,
          editingLanguageId = _ref.editingLanguageId,
          formId = _ref.formId,
          groupId = _ref.groupId,
          pages = _ref.pages,
          portletNamespace = _ref.portletNamespace,
          rules = _ref.rules;
      var formInstance = document.querySelector("[data-ddmforminstanceid=\"".concat(formId, "\"]"));
      var title = (0, _formId.getFormTitle)(formInstance);
      return function (dispatch) {
        (0, _evaluation.evaluate)(null, {
          defaultLanguageId: defaultLanguageId,
          editingLanguageId: editingLanguageId,
          groupId: groupId,
          pages: pages,
          portletNamespace: portletNamespace,
          rules: rules
        }).then(function (evaluatedPages) {
          var validPage = true;
          var visitor = new _visitors.PagesVisitor(evaluatedPages);
          visitor.mapFields(function (_ref2, fieldIndex, columnIndex, rowIndex, pageIndex) {
            var valid = _ref2.valid;

            if (activePage === pageIndex && !valid) {
              validPage = false;
            }
          }, true, true);

          if (validPage) {
            var nextActivePageIndex = evaluatedPages.findIndex(function (_ref3, index) {
              var enabled = _ref3.enabled;
              return enabled && index > activePage;
            });
            var activePageUpdated = Math.min(nextActivePageIndex, pages.length - 1);
            dispatch({
              payload: activePageUpdated,
              type: _eventTypes.EVENT_TYPES.CHANGE_ACTIVE_PAGE
            });
            Liferay.fire('ddmFormPageShow', {
              formId: formId,
              formPageTitle: pages[activePageUpdated].title,
              page: activePageUpdated,
              title: title
            });
          } else {
            dispatch({
              payload: {
                newPages: evaluatedPages,
                pageIndex: activePage
              },
              type: _eventTypes.EVENT_TYPES.PAGE_VALIDATION_FAILED
            });
          }
        });
      };
    }
    //# sourceMappingURL=nextPage.es.js.map
  }
});
//# sourceMappingURL=nextPage.es.js.map