Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.69/js/reducers/fieldReducer.es", ['module', 'exports', 'require', '../actions/eventTypes.es', '../util/repeatable.es', '../util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.updateNestedFieldNames = exports.createRepeatedField = void 0;

    var _eventTypes = require("../actions/eventTypes.es");

    var _repeatable = require("../util/repeatable.es");

    var _visitors = require("../util/visitors.es");

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var createRepeatedField = function createRepeatedField(sourceField, repeatedIndex) {
      var instanceId = (0, _repeatable.generateInstanceId)();
      return _objectSpread(_objectSpread({}, sourceField), {}, {
        instanceId: instanceId,
        localizedValue: {},
        name: (0, _repeatable.generateName)(sourceField.name, {
          instanceId: instanceId,
          repeatedIndex: repeatedIndex
        }),
        nestedFields: (sourceField.nestedFields || []).map(function (nestedField, index) {
          return createRepeatedField(nestedField, repeatedIndex + index);
        }),
        value: sourceField.predefinedValue
      });
    };

    exports.createRepeatedField = createRepeatedField;

    var updateNestedFieldNames = function updateNestedFieldNames(parentFieldName, nestedFields) {
      return (nestedFields || []).map(function (nestedField) {
        var newNestedFieldName = (0, _repeatable.generateNestedFieldName)(nestedField.name, parentFieldName);
        return _objectSpread(_objectSpread({}, nestedField), {}, {
          name: newNestedFieldName,
          nestedFields: updateNestedFieldNames(newNestedFieldName, nestedField.nestedFields)
        }, (0, _repeatable.parseNestedFieldName)(newNestedFieldName));
      });
    };

    exports.updateNestedFieldNames = updateNestedFieldNames;

    var _default = function _default(state, action) {
      switch (action.type) {
        case _eventTypes.EVENT_TYPES.FIELD_BLUR:
          {
            var fieldInstance = action.payload.fieldInstance;
            var pageVisitor = new _visitors.PagesVisitor(state.pages);
            return {
              pages: pageVisitor.mapFields(function (field) {
                var matches = field.name === fieldInstance.name && field.required && fieldInstance.value == '';
                return _objectSpread(_objectSpread({}, field), {}, {
                  displayErrors: !!field.displayErrors || matches,
                  focused: matches ? false : field.focused
                });
              })
            };
          }

        case _eventTypes.EVENT_TYPES.FIELD_FOCUS:
          {
            var _fieldInstance = action.payload.fieldInstance;

            var _pageVisitor = new _visitors.PagesVisitor(state.pages);

            return {
              pages: _pageVisitor.mapFields(function (field) {
                var focused = field.name === _fieldInstance.name;
                return _objectSpread(_objectSpread({}, field), {}, {
                  focused: focused
                });
              })
            };
          }

        case _eventTypes.EVENT_TYPES.FIELD_REMOVED:
          {
            var _pageVisitor2 = new _visitors.PagesVisitor(state.pages);

            var getParsedName = function getParsedName(name, parentFieldName) {
              if (parentFieldName) {
                return (0, _repeatable.parseNestedFieldName)(name);
              }

              return (0, _repeatable.parseName)(name);
            };

            return {
              pages: _pageVisitor2.mapColumns(function (column) {

                return _objectSpread(_objectSpread({}, column), {}, {
                  fields: function filter(fields, parentFieldName) {
                    var filteredFields = fields.filter(function (_ref) {
                      var name = _ref.name;
                      return name !== action.payload;
                    });
                    var parsedName = getParsedName(action.payload, parentFieldName);
                    var repeatedFields = filteredFields.filter(function (_ref2) {
                      var fieldName = _ref2.fieldName;
                      return fieldName === parsedName.fieldName;
                    }).map(function (field, index) {
                      var newName = (0, _repeatable.generateName)(field.name, {
                        repeatedIndex: index
                      });
                      return _objectSpread(_objectSpread({}, field), {}, {
                        nestedFields: updateNestedFieldNames(newName, field.nestedFields),
                        newName: newName
                      });
                    });
                    return filteredFields.map(function (field) {
                      var repeatedField = repeatedFields.find(function (_ref3) {
                        var name = _ref3.name;
                        return name === field.name;
                      });

                      if (repeatedField) {
                        field = _objectSpread(_objectSpread({}, repeatedField), {}, {
                          name: repeatedField.newName
                        });
                      }

                      return _objectSpread(_objectSpread({}, field), {}, {
                        nestedFields: field.nestedFields ? filter(field.nestedFields, field.name) : []
                      });
                    });
                  }(column.fields)
                });
              })
            };
          }

        case _eventTypes.EVENT_TYPES.FIELD_REPEATED:
          {
            var _pageVisitor3 = new _visitors.PagesVisitor(state.pages);

            return {
              pages: _pageVisitor3.mapColumns(function (column) {

                return _objectSpread(_objectSpread({}, column), {}, {
                  fields: function addRepeatedField(fields) {
                    var sourceFieldIndex = fields.reduce(function () {
                      var sourceFieldIndex = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : -1;
                      var field = arguments.length > 1 ? arguments[1] : undefined;
                      var index = arguments.length > 2 ? arguments[2] : undefined;

                      if (field.name === action.payload) {
                        sourceFieldIndex = index;
                      }

                      return sourceFieldIndex;
                    }, -1);

                    if (sourceFieldIndex > -1) {
                      var newFieldIndex = sourceFieldIndex + 1;
                      var newField = createRepeatedField(fields[sourceFieldIndex], newFieldIndex);
                      var currentRepeatedIndex = 0;
                      return [].concat(_toConsumableArray(fields.slice(0, newFieldIndex)), [newField], _toConsumableArray(fields.slice(newFieldIndex))).map(function (currentField) {
                        if (currentField.fieldName === newField.fieldName) {
                          var name = (0, _repeatable.generateName)(currentField.name, {
                            repeatedIndex: currentRepeatedIndex++
                          });
                          return _objectSpread(_objectSpread({}, currentField), {}, {
                            name: name,
                            nestedFields: updateNestedFieldNames(name, currentField.nestedFields)
                          });
                        }

                        return currentField;
                      });
                    }

                    return fields.map(function (field) {
                      return _objectSpread(_objectSpread({}, field), {}, {
                        nestedFields: field.nestedFields ? addRepeatedField(field.nestedFields) : []
                      });
                    });
                  }(column.fields)
                });
              })
            };
          }

        default:
          return state;
      }
    };

    exports.default = _default;
    //# sourceMappingURL=fieldReducer.es.js.map
  }
});
//# sourceMappingURL=fieldReducer.es.js.map