Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.69/js/components/Pagination.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/pagination', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../actions/eventTypes.es', '../hooks/useEvaluate.es', '../hooks/useForm.es', '../hooks/usePage.es', '../thunks/nextPage.es', '../thunks/previousPage.es', '../util/formId.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.Pagination = void 0;

    var _pagination = _interopRequireDefault(require("@frontend-taglib-clay$clayui/pagination"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _eventTypes = require("../actions/eventTypes.es");

    var _useEvaluate = require("../hooks/useEvaluate.es");

    var _useForm = require("../hooks/useForm.es");

    var _usePage2 = require("../hooks/usePage.es");

    var _nextPage = _interopRequireDefault(require("../thunks/nextPage.es"));

    var _previousPage = _interopRequireDefault(require("../thunks/previousPage.es"));

    var _formId = require("../util/formId.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
     * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
     */
    var Pagination = function Pagination(_ref) {
      var activePage = _ref.activePage,
          pages = _ref.pages;
      var createPreviousPage = (0, _useEvaluate.useEvaluate)(_previousPage.default);
      var createNextPage = (0, _useEvaluate.useEvaluate)(_nextPage.default);

      var _usePage = (0, _usePage2.usePage)(),
          containerElement = _usePage.containerElement;

      var dispatch = (0, _useForm.useForm)();
      return (/*#__PURE__*/_react.default.createElement(_pagination.default, {
          className: "ddm-pagination justify-content-center"
        }, /*#__PURE__*/_react.default.createElement("li", {
          className: (0, _classnames.default)('page-item', {
            'visibility-hidden': activePage === 0
          })
        }, /*#__PURE__*/_react.default.createElement("button", {
          className: "page-link",
          onClick: function onClick() {
            return dispatch(createPreviousPage({
              activePage: activePage,
              formId: (0, _formId.getFormId)((0, _formId.getFormNode)(containerElement.current))
            }));
          },
          type: "button"
        }, "\xAB", /*#__PURE__*/_react.default.createElement("span", {
          className: "sr-only"
        }, Liferay.Language.get('previous')))), pages.map(function (page, index) {
          return (/*#__PURE__*/_react.default.createElement(_pagination.default.Item, {
              active: activePage === index,
              disabled: !page.enabled,
              key: index,
              onClick: function onClick() {
                return dispatch({
                  payload: index,
                  type: _eventTypes.EVENT_TYPES.CHANGE_ACTIVE_PAGE
                });
              }
            }, page.paginationItemRenderer === 'paginated_success' ? Liferay.Language.get('success-page') : index + 1)
          );
        }), /*#__PURE__*/_react.default.createElement("li", {
          className: (0, _classnames.default)('page-item', {
            'visibility-hidden': activePage === pages.length - 1 || activePage === -1
          })
        }, /*#__PURE__*/_react.default.createElement("button", {
          className: "page-link",
          onClick: function onClick() {
            return dispatch(createNextPage({
              activePage: activePage,
              formId: (0, _formId.getFormId)((0, _formId.getFormNode)(containerElement.current))
            }));
          },
          type: "button"
        }, "\xBB", /*#__PURE__*/_react.default.createElement("span", {
          className: "sr-only"
        }, Liferay.Language.get('next')))))
      );
    };

    exports.Pagination = Pagination;
    //# sourceMappingURL=Pagination.es.js.map
  }
});
//# sourceMappingURL=Pagination.es.js.map