Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.69/js/components/PageRenderer/Layout.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../hooks/useEvaluate.es', '../../hooks/useForm.es', '../../hooks/usePage.es', '../../thunks/fieldBlur.es', '../../thunks/fieldChange.es', '../../thunks/fieldFocus.es', '../../util/formId.es', '../Field/Field.es', './DefaultVariant.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.Layout = void 0;

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _useEvaluate = require("../../hooks/useEvaluate.es");

    var _useForm = require("../../hooks/useForm.es");

    var _usePage2 = require("../../hooks/usePage.es");

    var _fieldBlur = _interopRequireDefault(require("../../thunks/fieldBlur.es"));

    var _fieldChange = _interopRequireDefault(require("../../thunks/fieldChange.es"));

    var _fieldFocus = _interopRequireDefault(require("../../thunks/fieldFocus.es"));

    var _formId = require("../../util/formId.es");

    var _Field = require("../Field/Field.es");

    var DefaultVariant = _interopRequireWildcard(require("./DefaultVariant.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    var Layout = function Layout(_ref) {
      var _ref$components = _ref.components,
          Components = _ref$components === void 0 ? DefaultVariant : _ref$components,
          editable = _ref.editable,
          rows = _ref.rows;

      var _usePage = (0, _usePage2.usePage)(),
          activePage = _usePage.activePage,
          allowNestedFields = _usePage.allowNestedFields,
          containerElement = _usePage.containerElement,
          pageIndex = _usePage.pageIndex,
          pages = _usePage.pages,
          spritemap = _usePage.spritemap;

      var createFieldChange = (0, _useEvaluate.useEvaluate)(_fieldChange.default);
      var dispatch = (0, _useForm.useForm)();
      var title = (0, _formId.getFormTitle)((0, _formId.getFormNode)(containerElement.current));
      return (/*#__PURE__*/_react.default.createElement(Components.Rows, {
          activePage: activePage,
          editable: editable,
          pageIndex: pageIndex,
          rows: rows
        }, function (_ref2) {
          var rowIndex = _ref2.index,
              row = _ref2.row;
          return (/*#__PURE__*/_react.default.createElement(Components.Row, {
              key: rowIndex,
              row: row
            }, function (_ref3) {
              var column = _ref3.column,
                  index = _ref3.index;
              return (/*#__PURE__*/_react.default.createElement(Components.Column, {
                  activePage: activePage,
                  allowNestedFields: allowNestedFields,
                  column: column,
                  editable: editable,
                  index: index,
                  key: index,
                  pageIndex: pageIndex,
                  rowIndex: rowIndex
                }, function (fieldProps) {
                  var _fieldProps$field$ins, _fieldProps$field;

                  return (/*#__PURE__*/_react.default.createElement(_Field.Field, _extends({}, fieldProps, {
                      activePage: activePage,
                      editable: editable,
                      key: (_fieldProps$field$ins = (_fieldProps$field = fieldProps.field) === null || _fieldProps$field === void 0 ? void 0 : _fieldProps$field.instanceId) !== null && _fieldProps$field$ins !== void 0 ? _fieldProps$field$ins : fieldProps.field.name,
                      onBlur: function onBlur(event, focusDuration) {
                        return dispatch((0, _fieldBlur.default)({
                          activePage: activePage,
                          focusDuration: focusDuration,
                          formId: (0, _formId.getFormId)((0, _formId.getFormNode)(containerElement.current)),
                          formPageTitle: Liferay.Util.escape(pages[activePage].title),
                          properties: event,
                          title: title
                        }));
                      },
                      onChange: function onChange(event) {
                        return dispatch(createFieldChange({
                          properties: event
                        }));
                      },
                      onFocus: function onFocus(event) {
                        return dispatch((0, _fieldFocus.default)({
                          activePage: activePage,
                          formId: (0, _formId.getFormId)((0, _formId.getFormNode)(containerElement.current)),
                          formPageTitle: Liferay.Util.escape(pages[activePage].title),
                          properties: event,
                          title: title
                        }));
                      },
                      pageIndex: pageIndex,
                      spritemap: spritemap
                    }))
                  );
                })
              );
            })
          );
        })
      );
    };

    exports.Layout = Layout;
    //# sourceMappingURL=Layout.es.js.map
  }
});
//# sourceMappingURL=Layout.es.js.map