Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.69/js/components/MultiStep.es", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../hooks/useEvaluate.es', '../hooks/useForm.es', '../hooks/usePage.es', '../thunks/nextPage.es', '../thunks/previousPage.es', '../util/formId.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.MultiStep = void 0;

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _useEvaluate = require("../hooks/useEvaluate.es");

    var _useForm = require("../hooks/useForm.es");

    var _usePage2 = require("../hooks/usePage.es");

    var _nextPage = _interopRequireDefault(require("../thunks/nextPage.es"));

    var _previousPage = _interopRequireDefault(require("../thunks/previousPage.es"));

    var _formId = require("../util/formId.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
     * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
     */
    var MultiStep = function MultiStep(_ref) {
      var activePage = _ref.activePage,
          editable = _ref.editable,
          pages = _ref.pages;

      var _usePage = (0, _usePage2.usePage)(),
          containerElement = _usePage.containerElement;

      var createPreviousPage = (0, _useEvaluate.useEvaluate)(_previousPage.default);
      var createNextPage = (0, _useEvaluate.useEvaluate)(_nextPage.default);
      var dispatch = (0, _useForm.useForm)();
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "ddm-form-pagination position-relative wizard-mode"
        }, /*#__PURE__*/_react.default.createElement("ol", {
          className: "ddm-wizard multi-step-indicator-label-top multi-step-nav multi-step-nav-collapse-sm"
        }, pages.map(function (page, index) {
          return (/*#__PURE__*/_react.default.createElement("li", {
              className: (0, _classnames.default)('multi-step-item', {
                active: index === activePage,
                complete: index < activePage,
                'multi-step-item-expand': index + 1 !== pages.length
              }),
              key: index,
              onClick: function onClick() {
                if (index < activePage) {
                  dispatch(createPreviousPage({
                    activePage: activePage,
                    formId: (0, _formId.getFormId)((0, _formId.getFormNode)(containerElement.current))
                  }));
                } else if (index > activePage) {
                  dispatch(createNextPage({
                    activePage: activePage,
                    formId: (0, _formId.getFormId)((0, _formId.getFormNode)(containerElement.current))
                  }));
                }
              }
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "multi-step-divider"
            }), /*#__PURE__*/_react.default.createElement("div", {
              className: "multi-step-indicator"
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "multi-step-indicator-label"
            }, page.paginationItemRenderer === 'wizard_success' ? Liferay.Language.get('success-page') : page.title ? page.title : Liferay.Language.get('untitled-page')), editable ? /*#__PURE__*/_react.default.createElement("a", {
              className: "multi-step-icon",
              "data-multi-step-icon": index + 1,
              href: "javascript:;"
            }) : /*#__PURE__*/_react.default.createElement("span", {
              className: "multi-step-icon",
              "data-multi-step-icon": index + 1
            })))
          );
        })))
      );
    };

    exports.MultiStep = MultiStep;
    //# sourceMappingURL=MultiStep.es.js.map
  }
});
//# sourceMappingURL=MultiStep.es.js.map