Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.2/js/store/actions/handlePaginationNextClicked.es", ['module', 'exports', 'require', '../../util/evaluation.es', '../../util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _evaluation = require("../../util/evaluation.es");

  var _visitors = require("../../util/visitors.es");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var _default = function _default(evaluatorContext, dispatch) {
    var activePage = evaluatorContext.activePage,
        formId = evaluatorContext.formId,
        pages = evaluatorContext.pages;
    return (0, _evaluation.evaluate)(null, evaluatorContext).then(function (evaluatedPages) {
      var validPage = true;
      var visitor = new _visitors.PagesVisitor(evaluatedPages);
      visitor.mapFields(function (_ref, fieldIndex, columnIndex, rowIndex, pageIndex) {
        var valid = _ref.valid;

        if (activePage === pageIndex && !valid) {
          validPage = false;
        }
      });

      if (validPage) {
        var nextActivePageIndex = evaluatedPages.findIndex(function (_ref2, index) {
          var enabled = _ref2.enabled;
          var found = false;

          if (enabled && index > activePage) {
            found = true;
          }

          return found;
        });
        var activePageUpdated = Math.min(nextActivePageIndex, pages.length - 1);
        dispatch('activePageUpdated', activePageUpdated);
        Liferay.fire('ddmFormPageShow', {
          formId: formId,
          page: activePageUpdated,
          title: pages[activePageUpdated].title
        });
      } else {
        dispatch('pageValidationFailed', activePage);
      }
    });
  };

  exports["default"] = _default;
  //# sourceMappingURL=handlePaginationNextClicked.es.js.map
});
//# sourceMappingURL=handlePaginationNextClicked.es.js.map