/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {evaluate} from '../../util/evaluation.es';

export default (evaluatorContext, dispatch) => {
	const {activePage, formId, pages} = evaluatorContext;

	return evaluate(null, evaluatorContext).then(evaluatedPages => {
		let previousActivePageIndex = activePage;

		for (let i = activePage - 1; i > -1; i--) {
			if (evaluatedPages[i].enabled) {
				previousActivePageIndex = i;

				break;
			}
		}

		const activePageUpdated = Math.max(previousActivePageIndex, 0);

		dispatch('activePageUpdated', activePageUpdated);

		Liferay.fire('ddmFormPageShow', {
			formId,
			page: activePageUpdated,
			title: pages[activePageUpdated].title
		});
	});
};
