Liferay.Loader.define("dynamic-data-mapping-form-renderer@4.0.40/js/util/repeatable.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.parseNestedFieldName = exports.parseName = exports.getRepeatedIndex = exports.generateNestedFieldName = exports.generateName = exports.generateInstanceId = void 0;

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var FIELD_NAME_REGEX = /(_\w+_)ddm\$\$(.+)\$(\w+)\$(\d+)\$\$(\w+)/;
  var NESTED_FIELD_NAME_REGEX = /(_\w+_)ddm\$\$(.+)\$(\w+)\$(\d+)#(.+)\$(\w+)\$(\d+)\$\$(\w+)/;

  var generateInstanceId = function generateInstanceId() {
    return Math.random().toString(36).substr(2, 8);
  };

  exports.generateInstanceId = generateInstanceId;

  var generateName = function generateName(name, repeatedIndex) {
    var parsedName = parseName(name);
    var fieldName = parsedName.fieldName,
        instanceId = parsedName.instanceId,
        locale = parsedName.locale,
        portletNamespace = parsedName.portletNamespace;
    return "".concat(portletNamespace, "ddm$$").concat(fieldName, "$").concat(instanceId, "$").concat(repeatedIndex, "$$").concat(locale);
  };

  exports.generateName = generateName;

  var generateNestedFieldName = function generateNestedFieldName(name, parentFieldName) {
    var parsedName = parseNestedFieldName(name);
    var parsedParentFieldName = parseName(parentFieldName);
    var fieldName = parsedName.fieldName,
        instanceId = parsedName.instanceId,
        locale = parsedName.locale,
        portletNamespace = parsedName.portletNamespace,
        repeatedIndex = parsedName.repeatedIndex;
    return [portletNamespace, 'ddm$$', parsedParentFieldName.fieldName, '$', parsedParentFieldName.instanceId, '$', parsedParentFieldName.repeatedIndex, '#', fieldName, '$', instanceId, '$', repeatedIndex, '$$', locale].join('');
  };

  exports.generateNestedFieldName = generateNestedFieldName;

  var getRepeatedIndex = function getRepeatedIndex(name) {
    var parsedName;

    if (NESTED_FIELD_NAME_REGEX.test(name)) {
      parsedName = parseNestedFieldName(name);
    } else {
      parsedName = parseName(name);
    }

    return parsedName.repeatedIndex;
  };

  exports.getRepeatedIndex = getRepeatedIndex;

  var parseName = function parseName(name) {
    var parsed = {};
    var result = FIELD_NAME_REGEX.exec(name);

    if (result) {
      parsed = {
        fieldName: result[2],
        instanceId: result[3],
        locale: result[5],
        portletNamespace: result[1],
        repeatedIndex: Number(result[4])
      };
    }

    return parsed;
  };

  exports.parseName = parseName;

  var parseNestedFieldName = function parseNestedFieldName(name) {
    var parsed = {};
    var result = NESTED_FIELD_NAME_REGEX.exec(name);

    if (result) {
      parsed = {
        fieldName: result[5],
        instanceId: result[6],
        locale: result[8],
        parentFieldName: result[2],
        parentInstanceId: result[3],
        parentRepeatedIndex: Number(result[4]),
        portletNamespace: result[1],
        repeatedIndex: Number(result[7])
      };
    }

    return parsed;
  };

  exports.parseNestedFieldName = parseNestedFieldName;
  //# sourceMappingURL=repeatable.es.js.map
});
//# sourceMappingURL=repeatable.es.js.map