/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {
	generateInstanceId,
	generateName,
	generateNestedFieldName
} from '../../util/repeatable.es';
import {PagesVisitor} from '../../util/visitors.es';

export default (pages, name) => {
	const visitor = new PagesVisitor(pages);

	return visitor.mapColumns(column => {
		const {fields} = column;
		const currentIndex = fields.reduce(
			(currentIndex = -1, field, index) => {
				if (field.name === name) {
					currentIndex = index;
				}

				return currentIndex;
			},
			-1
		);

		if (currentIndex > -1) {
			const field = fields[currentIndex];
			const indexToAddField = currentIndex + 1;
			const newField = {
				...field,
				instanceId: generateInstanceId(),
				name: generateName(name, indexToAddField)
			};

			newField.localizedValue = {};

			delete newField.value;

			const newFields = [
				...fields.slice(0, indexToAddField),
				newField,
				...fields.slice(indexToAddField)
			];

			let currentRepeatedIndex = 0;

			column = {
				...column,
				fields: newFields.map((currentField, index) => {
					if (currentField.fieldName === newField.fieldName) {
						const name = generateName(
							currentField.name,
							currentRepeatedIndex++
						);

						currentField = {
							...currentField,
							name
						};

						if (currentField.nestedFields) {
							currentField = {
								...currentField,
								nestedFields: currentField.nestedFields.map(
									nestedField => {
										const newNestedField = {
											...nestedField,
											name: generateNestedFieldName(
												nestedField.name,
												name
											)
										};

										if (index === indexToAddField) {
											newField.localizedValue = {};

											delete newNestedField.value;
										}

										return newNestedField;
									}
								)
							};
						}
					}

					return currentField;
				})
			};
		}

		return column;
	});
};
