/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Locale;

public class DefaultDDMFormValuesFactory {
    private final DDMForm _ddmForm;
    private final Locale _locale;

    public DefaultDDMFormValuesFactory(DDMForm ddmForm, Locale locale) {
        this._ddmForm = ddmForm;
        this._locale = locale;
    }

    public DDMFormValues create() {
        DDMFormValues ddmFormValues = new DDMFormValues(this._ddmForm);
        ddmFormValues.addAvailableLocale(this._locale);
        ddmFormValues.setDefaultLocale(this._locale);
        for (DDMFormField ddmFormField : this._ddmForm.getDDMFormFields()) {
            DDMFormFieldValue ddmFormFieldValue = this.createDefaultDDMFormFieldValue(ddmFormField);
            ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
        }
        return ddmFormValues;
    }

    protected DDMFormFieldValue createDefaultDDMFormFieldValue(DDMFormField ddmFormField) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setName(ddmFormField.getName());
        Value value = this.createDefaultValue(ddmFormField);
        ddmFormFieldValue.setValue(value);
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            ddmFormFieldValue.addNestedDDMFormFieldValue(this.createDefaultDDMFormFieldValue(nestedDDMFormField));
        }
        return ddmFormFieldValue;
    }

    protected Value createDefaultLocalizedValue(String defaultValueString) {
        LocalizedValue value = new LocalizedValue(this._locale);
        value.addString(this._locale, defaultValueString);
        return value;
    }

    protected Value createDefaultValue(DDMFormField ddmFormField) {
        LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
        String defaultValueString = GetterUtil.getString((String)predefinedValue.getString(this._locale));
        if (ddmFormField.isLocalizable()) {
            return this.createDefaultLocalizedValue(defaultValueString);
        }
        return new UnlocalizedValue(defaultValueString);
    }
}

