/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingException;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.form.renderer.internal.servlet.taglib.DDMFormFieldTypesDynamicInclude;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.servlet.taglib.DynamicIncludeUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.MapUtil;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"templatePath=/META-INF/resources/form.soy"})
public class DDMFormRendererImpl
implements DDMFormRenderer {
    @Reference
    private DDM _ddm;
    @Reference
    private DDMFormTemplateContextFactory _ddmFormTemplateContextFactory;
    private TemplateResource _templateResource;

    @Override
    public String render(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws DDMFormRenderingException {
        try {
            return this.doRender(ddmForm, ddmFormLayout, ddmFormRenderingContext);
        }
        catch (DDMFormRenderingException ddmfre) {
            throw ddmfre;
        }
        catch (PortalException pe) {
            throw new DDMFormRenderingException(pe);
        }
    }

    @Override
    public String render(DDMForm ddmForm, DDMFormRenderingContext ddmFormRenderingContext) throws DDMFormRenderingException {
        try {
            return this.doRender(ddmForm, this._ddm.getDefaultDDMFormLayout(ddmForm), ddmFormRenderingContext);
        }
        catch (DDMFormRenderingException ddmfre) {
            throw ddmfre;
        }
        catch (PortalException pe) {
            throw new DDMFormRenderingException(pe);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        String templatePath = MapUtil.getString(properties, (String)"templatePath");
        this._templateResource = this.getTemplateResource(templatePath);
    }

    protected String doRender(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws PortalException {
        Template template = TemplateManagerUtil.getTemplate((String)"soy", (TemplateResource)this._templateResource, (boolean)false);
        this.populateCommonContext(template, ddmForm, ddmFormLayout, ddmFormRenderingContext);
        String templateNamespace = (String)template.get("templateNamespace");
        String html = this.render(template, templateNamespace);
        String javaScript = this.render(template, "ddm.form_renderer_js");
        DynamicIncludeUtil.include((HttpServletRequest)ddmFormRenderingContext.getHttpServletRequest(), (HttpServletResponse)ddmFormRenderingContext.getHttpServletResponse(), (String)DDMFormFieldTypesDynamicInclude.class.getName(), (boolean)true);
        return html.concat(javaScript);
    }

    protected TemplateResource getTemplateResource(String templatePath) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        URL templateURL = classLoader.getResource(templatePath);
        return new URLTemplateResource(templateURL.getPath(), templateURL);
    }

    protected void populateCommonContext(Template template, DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws PortalException {
        Map<String, Object> ddmFormTemplateContext = this._ddmFormTemplateContextFactory.create(ddmForm, ddmFormLayout, ddmFormRenderingContext);
        template.putAll(ddmFormTemplateContext);
    }

    protected String render(Template template, String namespace) throws TemplateException {
        UnsyncStringWriter writer = new UnsyncStringWriter();
        template.put((Object)"namespace", (Object)namespace);
        template.put((Object)"render_strict", (Object)Boolean.FALSE);
        template.processTemplate((Writer)writer);
        return writer.toString();
    }

    @Reference(unbind="-")
    protected void setDDM(DDM ddm) {
        this._ddm = ddm;
    }
}

