/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluationException;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluationResult;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluator;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormFieldEvaluationResult;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldRenderer;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingException;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRenderingContext;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDMFormRendererHelper {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormRendererHelper.class);
    private final DDMForm _ddmForm;
    private DDMFormEvaluator _ddmFormEvaluator;
    private Map<String, DDMFormFieldEvaluationResult> _ddmFormFieldEvaluationResultsMap;
    private final Map<String, DDMFormField> _ddmFormFieldsMap;
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private final DDMFormRenderingContext _ddmFormRenderingContext;
    private final DDMFormValues _ddmFormValues;

    public DDMFormRendererHelper(DDMForm ddmForm, DDMFormRenderingContext ddmFormRenderingContext) {
        this._ddmForm = ddmForm;
        this._ddmFormRenderingContext = ddmFormRenderingContext;
        this._ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        DDMFormValues ddmFormValues = ddmFormRenderingContext.getDDMFormValues();
        this._ddmFormValues = ddmFormValues == null ? this.createDefaultDDMFormValues() : ddmFormValues;
    }

    public Map<String, String> getRenderedDDMFormFieldsMap() throws DDMFormRenderingException {
        HashMap<String, String> renderedDDMFormFieldValuesMap = new HashMap<String, String>();
        Map ddmFormFieldValuesMap = this._ddmFormValues.getDDMFormFieldValuesMap();
        for (Map.Entry entry : ddmFormFieldValuesMap.entrySet()) {
            renderedDDMFormFieldValuesMap.put((String)entry.getKey(), this.renderDDMFormFieldValues((List)entry.getValue(), ""));
        }
        return renderedDDMFormFieldValuesMap;
    }

    protected DDMFormFieldRenderingContext createDDMFormFieldRenderingContext() {
        DDMFormFieldRenderingContext ddmFormFieldRenderingContext = new DDMFormFieldRenderingContext();
        ddmFormFieldRenderingContext.setChildElementsHTML("");
        ddmFormFieldRenderingContext.setHttpServletRequest(this._ddmFormRenderingContext.getHttpServletRequest());
        ddmFormFieldRenderingContext.setHttpServletResponse(this._ddmFormRenderingContext.getHttpServletResponse());
        ddmFormFieldRenderingContext.setLabel("");
        ddmFormFieldRenderingContext.setLocale(this._ddmFormRenderingContext.getLocale());
        ddmFormFieldRenderingContext.setName("");
        ddmFormFieldRenderingContext.setPortletNamespace(this._ddmFormRenderingContext.getPortletNamespace());
        ddmFormFieldRenderingContext.setReadOnly(this._ddmFormRenderingContext.isReadOnly());
        ddmFormFieldRenderingContext.setValue("");
        return ddmFormFieldRenderingContext;
    }

    protected DDMFormFieldValue createDefaultDDMFormFieldValue(DDMFormField ddmFormField) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setName(ddmFormField.getName());
        Value value = this.createDefaultValue(ddmFormField);
        ddmFormFieldValue.setValue(value);
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            ddmFormFieldValue.addNestedDDMFormFieldValue(this.createDefaultDDMFormFieldValue(nestedDDMFormField));
        }
        return ddmFormFieldValue;
    }

    protected DDMFormValues createDefaultDDMFormValues() {
        DDMFormValues ddmFormValues = new DDMFormValues(this._ddmForm);
        ddmFormValues.setDefaultLocale(this._ddmFormRenderingContext.getLocale());
        for (DDMFormField ddmFormField : this._ddmForm.getDDMFormFields()) {
            DDMFormFieldValue ddmFormFieldValue = this.createDefaultDDMFormFieldValue(ddmFormField);
            ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
        }
        return ddmFormValues;
    }

    protected Value createDefaultLocalizedValue(String defaultValueString) {
        LocalizedValue value = new LocalizedValue(this._ddmFormRenderingContext.getLocale());
        value.addString(this._ddmFormRenderingContext.getLocale(), defaultValueString);
        return value;
    }

    protected Value createDefaultValue(DDMFormField ddmFormField) {
        LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
        String defaultValueString = GetterUtil.getString((String)predefinedValue.getString(this._ddmFormRenderingContext.getLocale()));
        if (ddmFormField.isLocalizable()) {
            return this.createDefaultLocalizedValue(defaultValueString);
        }
        return new UnlocalizedValue(defaultValueString);
    }

    protected Map<String, DDMFormFieldEvaluationResult> createInitialStateDDMFormFieldEvaluationResultsMap() {
        try {
            DDMFormEvaluationResult ddmFormEvaluationResult = this._ddmFormEvaluator.evaluate(this._ddmForm, this._ddmFormValues, this._ddmFormRenderingContext.getLocale());
            return ddmFormEvaluationResult.getDDMFormFieldEvaluationResultsMap();
        }
        catch (DDMFormEvaluationException ddmfee) {
            _log.error((Object)"Unable to evaluate the form", (Throwable)ddmfee);
            return new HashMap<String, DDMFormFieldEvaluationResult>();
        }
    }

    protected Map<String, DDMFormFieldEvaluationResult> evaluateDDMForm(Locale locale) throws DDMFormRenderingException {
        try {
            DDMFormEvaluationResult ddmFormEvaluationResult = this._ddmFormEvaluator.evaluate(this._ddmForm, this._ddmFormValues, locale);
            return ddmFormEvaluationResult.getDDMFormFieldEvaluationResultsMap();
        }
        catch (DDMFormEvaluationException ddmfee) {
            throw new DDMFormRenderingException(ddmfee);
        }
    }

    protected String getAffixedDDMFormFieldParameterName(String ddmFormFieldParameterName) {
        StringBundler sb = new StringBundler(5);
        sb.append(this._ddmFormRenderingContext.getPortletNamespace());
        sb.append("ddm$$");
        sb.append(ddmFormFieldParameterName);
        sb.append("$$");
        Locale locale = this._ddmForm.getDefaultLocale();
        if (locale == null) {
            locale = this._ddmFormRenderingContext.getLocale();
        }
        sb.append(LocaleUtil.toLanguageId((Locale)locale));
        return sb.toString();
    }

    protected String getDDMFormFieldParameterName(String ddmFormFieldName, String instanceId, int index, String parentDDMFormFieldParameterName) {
        StringBundler sb = new StringBundler(7);
        if (Validator.isNotNull((String)parentDDMFormFieldParameterName)) {
            sb.append(parentDDMFormFieldParameterName);
            sb.append("#");
        }
        sb.append(ddmFormFieldName);
        sb.append("$");
        sb.append(instanceId);
        sb.append("$");
        sb.append(index);
        return sb.toString();
    }

    protected boolean isFieldVisible(String fieldName) {
        DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult;
        if (this._ddmFormFieldEvaluationResultsMap == null) {
            this._ddmFormFieldEvaluationResultsMap = this.createInitialStateDDMFormFieldEvaluationResultsMap();
        }
        if ((ddmFormFieldEvaluationResult = this._ddmFormFieldEvaluationResultsMap.get(fieldName)) != null) {
            return ddmFormFieldEvaluationResult.isVisible();
        }
        return true;
    }

    protected String renderDDMFormField(DDMFormField ddmFormField, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) throws DDMFormRenderingException {
        DDMFormFieldRenderer ddmFormFieldRenderer = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldRenderer(ddmFormField.getType());
        if (ddmFormFieldRenderer == null) {
            throw new DDMFormRenderingException("No DDM form field renderer registered for " + ddmFormField.getType());
        }
        try {
            String ddmFormFieldHTML = ddmFormFieldRenderer.render(ddmFormField, ddmFormFieldRenderingContext);
            return this.wrapDDMFormFieldHTML(ddmFormFieldHTML, ddmFormFieldRenderingContext.isVisible());
        }
        catch (PortalException pe) {
            throw new DDMFormRenderingException(pe);
        }
    }

    protected String renderDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) throws DDMFormRenderingException {
        DDMFormField ddmFormField = this._ddmFormFieldsMap.get(ddmFormFieldValue.getName());
        this.setDDMFormFieldRenderingContextLabel(ddmFormField.getLabel(), ddmFormFieldRenderingContext);
        this.setDDMFormFieldRenderingContextRequired(ddmFormField.isRequired(), ddmFormFieldRenderingContext);
        this.setDDMFormFieldRenderingContextRequired(ddmFormField.isRequired(), ddmFormFieldRenderingContext);
        this.setDDMFormFieldRenderingContextTip(ddmFormField.getTip(), ddmFormFieldRenderingContext);
        this.setDDMFormFieldRenderingContextValue(ddmFormFieldValue.getValue(), ddmFormFieldRenderingContext);
        this.setDDMFormFieldRenderingContextVisible(ddmFormField.getVisibilityExpression(), ddmFormFieldValue.getName(), ddmFormFieldRenderingContext);
        return this.renderDDMFormField(ddmFormField, ddmFormFieldRenderingContext);
    }

    protected String renderDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue, int index, String parentDDMFormFieldParameterName) throws DDMFormRenderingException {
        String ddmFormFieldParameterName = this.getDDMFormFieldParameterName(ddmFormFieldValue.getName(), ddmFormFieldValue.getInstanceId(), index, parentDDMFormFieldParameterName);
        Map nestedDDMFormFieldValuesMap = ddmFormFieldValue.getNestedDDMFormFieldValuesMap();
        StringBundler sb = new StringBundler(nestedDDMFormFieldValuesMap.size());
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            List nestedDDMFormFieldValues = (List)nestedDDMFormFieldValuesMap.get(nestedDDMFormFieldValue.getName());
            sb.append(this.renderDDMFormFieldValues(nestedDDMFormFieldValues, ddmFormFieldParameterName));
        }
        DDMFormFieldRenderingContext ddmFormFieldRenderingContext = this.createDDMFormFieldRenderingContext();
        this.setDDMFormFieldRenderingContextChildElementsHTML(sb.toString(), ddmFormFieldRenderingContext);
        this.setDDMFormFieldRenderingContextName(ddmFormFieldParameterName, ddmFormFieldRenderingContext);
        return this.renderDDMFormFieldValue(ddmFormFieldValue, ddmFormFieldRenderingContext);
    }

    protected String renderDDMFormFieldValues(List<DDMFormFieldValue> ddmFormFieldValues, String parentDDMFormFieldParameterName) throws DDMFormRenderingException {
        StringBundler sb = new StringBundler(ddmFormFieldValues.size());
        int index = 0;
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            sb.append(this.renderDDMFormFieldValue(ddmFormFieldValue, index++, parentDDMFormFieldParameterName));
        }
        return sb.toString();
    }

    protected void setDDMFormEvaluator(DDMFormEvaluator ddmFormEvaluator) {
        this._ddmFormEvaluator = ddmFormEvaluator;
    }

    protected void setDDMFormFieldRenderingContextChildElementsHTML(String childElementsHTML, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
        ddmFormFieldRenderingContext.setChildElementsHTML(childElementsHTML);
    }

    protected void setDDMFormFieldRenderingContextLabel(LocalizedValue label, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
        Map values = label.getValues();
        if (values.isEmpty()) {
            return;
        }
        ddmFormFieldRenderingContext.setLabel(label.getString(ddmFormFieldRenderingContext.getLocale()));
    }

    protected void setDDMFormFieldRenderingContextName(String ddmFormFieldParameterName, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
        String name = this.getAffixedDDMFormFieldParameterName(ddmFormFieldParameterName);
        ddmFormFieldRenderingContext.setName(name);
    }

    protected void setDDMFormFieldRenderingContextRequired(boolean required, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
        ddmFormFieldRenderingContext.setRequired(required);
    }

    protected void setDDMFormFieldRenderingContextTip(LocalizedValue tip, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
        Map values = tip.getValues();
        if (values.isEmpty()) {
            return;
        }
        ddmFormFieldRenderingContext.setTip(tip.getString(ddmFormFieldRenderingContext.getLocale()));
    }

    protected void setDDMFormFieldRenderingContextValue(Value value, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
        if (value == null) {
            return;
        }
        ddmFormFieldRenderingContext.setValue(value.getString(ddmFormFieldRenderingContext.getLocale()));
    }

    protected void setDDMFormFieldRenderingContextVisible(String visibilityExpression, String fieldName, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) throws DDMFormRenderingException {
        boolean visible = this.isFieldVisible(fieldName);
        if (Validator.isNotNull((String)visibilityExpression)) {
            Map<String, DDMFormFieldEvaluationResult> ddmFormFieldEvaluationResultsMap = this.evaluateDDMForm(ddmFormFieldRenderingContext.getLocale());
            DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult = ddmFormFieldEvaluationResultsMap.get(fieldName);
            visible = ddmFormFieldEvaluationResult.isVisible();
        }
        ddmFormFieldRenderingContext.setVisible(visible);
    }

    protected void setDDMFormFieldTypeServicesTracker(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
    }

    protected String wrapDDMFormFieldHTML(String ddmFormFieldHTML, boolean visible) {
        StringBundler sb = new StringBundler(5);
        sb.append("<div class=\"");
        if (!visible) {
            sb.append("hide ");
        }
        sb.append("lfr-ddm-form-field-container\">");
        sb.append(ddmFormFieldHTML);
        sb.append("</div>");
        return sb.toString();
    }
}

