/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.context;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormSuccessPageSettings;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormLayoutFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DDMFormBuilderContextFactoryHelper {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormBuilderContextFactoryHelper.class);
    private final DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private final DDMFormTemplateContextFactory _ddmFormTemplateContextFactory;
    private final Optional<DDMStructure> _ddmStructureOptional;
    private final Optional<DDMStructureVersion> _ddmStructureVersionOptional;
    private final HttpServletRequest _httpServletRequest;
    private final HttpServletResponse _httpServletResponse;
    private final JSONFactory _jsonFactory;
    private final Locale _locale;
    private final String _portletNamespace;
    private final boolean _readOnly;

    public DDMFormBuilderContextFactoryHelper(Optional<DDMStructure> ddmStructureOptional, Optional<DDMStructureVersion> ddmStructureVersionOptional, DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker, DDMFormTemplateContextFactory ddmFormTemplateContextFactory, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, JSONFactory jsonFactory, Locale locale, String portletNamespace, boolean readOnly) {
        this._ddmStructureOptional = ddmStructureOptional;
        this._ddmStructureVersionOptional = ddmStructureVersionOptional;
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
        this._ddmFormTemplateContextFactory = ddmFormTemplateContextFactory;
        this._httpServletRequest = httpServletRequest;
        this._httpServletResponse = httpServletResponse;
        this._jsonFactory = jsonFactory;
        this._locale = locale;
        this._portletNamespace = portletNamespace;
        this._readOnly = readOnly;
    }

    public Map<String, Object> create() {
        Optional<Map> contextOptional = Optional.empty();
        if (this._ddmStructureVersionOptional.isPresent()) {
            contextOptional = this._ddmStructureVersionOptional.map(this::createFormContext);
        }
        if (this._ddmStructureOptional.isPresent()) {
            contextOptional = this._ddmStructureOptional.map(this::createFormContext);
        }
        return contextOptional.orElseGet(this::createEmptyStateContext);
    }

    protected Map<String, Object> createEmptyStateContext() {
        return HashMapBuilder.put((Object)"pages", new ArrayList()).put((Object)"rules", new ArrayList()).put((Object)"successPage", (Object)HashMapBuilder.put((Object)"body", (Object)"").put((Object)"enabled", (Object)Boolean.FALSE).put((Object)"title", (Object)"").build()).build();
    }

    protected Map<String, Object> createFormContext(DDMForm ddmForm, DDMFormLayout ddmFormLayout) throws PortalException {
        DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
        ddmFormRenderingContext.setHttpServletRequest(this._httpServletRequest);
        ddmFormRenderingContext.setHttpServletResponse(this._httpServletResponse);
        ddmFormRenderingContext.setLocale(this._locale);
        ddmFormRenderingContext.setPortletNamespace(this._portletNamespace);
        ddmFormRenderingContext.setReadOnly(this._readOnly);
        Map ddmFormTemplateContext = this._ddmFormTemplateContextFactory.create(ddmForm, ddmFormLayout, ddmFormRenderingContext);
        this.populateDDMFormFieldSettingsContext(ddmFormTemplateContext, ddmForm.getDDMFormFieldsMap(true));
        return ddmFormTemplateContext;
    }

    protected Map<String, Object> createFormContext(DDMStructure ddmStructure) {
        try {
            return this.doCreateFormContext(ddmStructure);
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to create form context", (Throwable)portalException);
            return this.createEmptyStateContext();
        }
    }

    protected Map<String, Object> createFormContext(DDMStructureVersion ddmStructureVersion) {
        try {
            return this.doCreateFormContext(ddmStructureVersion);
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to create form context", (Throwable)portalException);
            return this.createEmptyStateContext();
        }
    }

    protected JSONArray createOptions(DDMFormFieldOptions ddmFormFieldOptions, Locale locale) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (String optionValue : ddmFormFieldOptions.getOptionsValues()) {
            JSONObject jsonObject = this._jsonFactory.createJSONObject();
            LocalizedValue label = ddmFormFieldOptions.getOptionLabels(optionValue);
            jsonObject.put("label", label.getString(locale)).put("reference", ddmFormFieldOptions.getOptionReference(optionValue)).put("value", optionValue);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    protected Map<String, Object> doCreateDDMFormFieldSettingContext(DDMFormField ddmFormField) throws PortalException {
        DDMFormFieldType ddmFormFieldType = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldType(ddmFormField.getType());
        DDMForm ddmForm = DDMFormFactory.create((Class)ddmFormFieldType.getDDMFormFieldTypeSettings());
        DDMFormLayout ddmFormLayout = DDMFormLayoutFactory.create((Class)ddmFormFieldType.getDDMFormFieldTypeSettings());
        DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
        ddmFormRenderingContext.setContainerId("settings");
        ddmFormRenderingContext.setHttpServletRequest(this._httpServletRequest);
        ddmFormRenderingContext.setHttpServletResponse(this._httpServletResponse);
        ddmFormRenderingContext.setLocale(this._locale);
        ddmFormRenderingContext.setPortletNamespace(this._portletNamespace);
        DDMFormValues ddmFormValues = this.doCreateDDMFormFieldSettingContextDDMFormValues(ddmForm, ddmFormField);
        ddmFormRenderingContext.setDDMFormValues(ddmFormValues);
        return this._ddmFormTemplateContextFactory.create(ddmForm, ddmFormLayout, ddmFormRenderingContext);
    }

    protected DDMFormValues doCreateDDMFormFieldSettingContextDDMFormValues(DDMForm ddmFormFieldTypeSettingsDDMForm, DDMFormField ddmFormField) {
        Map ddmFormFieldProperties = ddmFormField.getProperties();
        DDMFormValues ddmFormValues = new DDMFormValues(ddmFormFieldTypeSettingsDDMForm);
        for (DDMFormField ddmFormFieldTypeSetting : ddmFormFieldTypeSettingsDDMForm.getDDMFormFields()) {
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
            ddmFormFieldValue.setFieldReference(ddmFormFieldTypeSetting.getFieldReference());
            String propertyName = ddmFormFieldTypeSetting.getName();
            ddmFormFieldValue.setName(propertyName);
            DDMForm ddmForm = ddmFormField.getDDMForm();
            Value value = this.doCreateDDMFormFieldValue(ddmFormFieldTypeSetting, ddmFormFieldProperties.get(propertyName), ddmForm.getAvailableLocales());
            ddmFormFieldValue.setValue(value);
            ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
        }
        return ddmFormValues;
    }

    protected Value doCreateDDMFormFieldValue(DDMFormField ddmFormFieldTypeSetting, Object propertyValue, Set<Locale> availableLocales) {
        if (ddmFormFieldTypeSetting.isLocalizable()) {
            return (LocalizedValue)propertyValue;
        }
        if (Objects.equals(ddmFormFieldTypeSetting.getDataType(), "ddm-options")) {
            return this.doCreateDDMFormFieldValue((DDMFormFieldOptions)propertyValue, availableLocales);
        }
        if (Objects.equals(ddmFormFieldTypeSetting.getName(), "requiredDescription") && propertyValue == null) {
            return new UnlocalizedValue(Boolean.TRUE.toString());
        }
        if (Objects.equals(ddmFormFieldTypeSetting.getType(), "validation")) {
            return this.doCreateDDMFormFieldValue(availableLocales, (DDMFormFieldValidation)propertyValue);
        }
        return new UnlocalizedValue(String.valueOf(propertyValue));
    }

    protected Value doCreateDDMFormFieldValue(DDMFormFieldOptions ddmFormFieldOptions, Set<Locale> availableLocales) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        for (Locale availableLocale : availableLocales) {
            jsonObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), this.createOptions(ddmFormFieldOptions, availableLocale));
        }
        return new UnlocalizedValue(jsonObject.toString());
    }

    protected Value doCreateDDMFormFieldValue(Set<Locale> availableLocales, DDMFormFieldValidation ddmFormFieldValidation) {
        if (ddmFormFieldValidation == null) {
            return null;
        }
        JSONObject errorMessageJSONObject = this._jsonFactory.createJSONObject();
        JSONObject parameterJSONObject = this._jsonFactory.createJSONObject();
        for (Locale availableLocale : availableLocales) {
            LocalizedValue errorMessageLocalizedValue = ddmFormFieldValidation.getErrorMessageLocalizedValue();
            errorMessageJSONObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), errorMessageLocalizedValue.getString(availableLocale));
            LocalizedValue parameterLocalizedValue = ddmFormFieldValidation.getParameterLocalizedValue();
            parameterJSONObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), parameterLocalizedValue.getString(availableLocale));
        }
        DDMFormFieldValidationExpression ddmFormFieldValidationExpression = ddmFormFieldValidation.getDDMFormFieldValidationExpression();
        JSONObject expressionJSONObject = this._jsonFactory.createJSONObject();
        expressionJSONObject.put("name", GetterUtil.getString((String)ddmFormFieldValidationExpression.getName())).put("value", GetterUtil.getString((String)ddmFormFieldValidationExpression.getValue()));
        return new UnlocalizedValue(JSONUtil.put((String)"errorMessage", (Object)errorMessageJSONObject).put("expression", expressionJSONObject).put("parameter", parameterJSONObject).toString());
    }

    protected Map<String, Object> doCreateFormContext(DDMForm ddmForm, DDMFormLayout ddmFormLayout) throws PortalException {
        return HashMapBuilder.put((Object)"pages", () -> {
            Map<String, Object> formContext = this.createFormContext(ddmForm, ddmFormLayout);
            return formContext.get("pages");
        }).put((Object)"paginationMode", (Object)ddmFormLayout.getPaginationMode()).put((Object)"rules", new ArrayList()).put((Object)"successPageSettings", () -> {
            DDMFormSuccessPageSettings ddmFormSuccessPageSettings = ddmForm.getDDMFormSuccessPageSettings();
            return HashMapBuilder.put((Object)"body", this.toMap(ddmFormSuccessPageSettings.getBody())).put((Object)"enabled", (Object)ddmFormSuccessPageSettings.isEnabled()).put((Object)"title", this.toMap(ddmFormSuccessPageSettings.getTitle())).build();
        }).build();
    }

    protected Map<String, Object> doCreateFormContext(DDMStructure ddmStructure) throws PortalException {
        return this.doCreateFormContext(ddmStructure.getDDMForm(), ddmStructure.getDDMFormLayout());
    }

    protected Map<String, Object> doCreateFormContext(DDMStructureVersion ddmStructureVersion) throws PortalException {
        return this.doCreateFormContext(ddmStructureVersion.getDDMForm(), ddmStructureVersion.getDDMFormLayout());
    }

    protected void populateDDMFormFieldSettingsContext(Map<String, Object> ddmFormTemplateContext, final Map<String, DDMFormField> ddmFormFieldsMap) {
        DDMFormBuilderContextFieldVisitor ddmFormBuilderContextFieldVisitor = new DDMFormBuilderContextFieldVisitor(ddmFormTemplateContext, new Consumer<Map<String, Object>>(){

            @Override
            public void accept(Map<String, Object> fieldContext) {
                String fieldName = MapUtil.getString(fieldContext, (String)"fieldName");
                try {
                    fieldContext.put("settingsContext", DDMFormBuilderContextFactoryHelper.this.doCreateDDMFormFieldSettingContext((DDMFormField)ddmFormFieldsMap.get(fieldName)));
                }
                catch (PortalException portalException) {
                    _log.error((Object)"Unable to create field settings context", (Throwable)portalException);
                }
            }
        });
        ddmFormBuilderContextFieldVisitor.visit();
    }

    protected Map<String, Object> toMap(LocalizedValue localizedValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map values = localizedValue.getValues();
        for (Map.Entry entry : values.entrySet()) {
            map.put(LanguageUtil.getLanguageId((Locale)((Locale)entry.getKey())), entry.getValue());
        }
        return map;
    }

    private static class DDMFormBuilderContextFieldVisitor {
        private final Map<String, Object> _ddmFormBuilderContext;
        private final Consumer<Map<String, Object>> _fieldConsumer;

        public DDMFormBuilderContextFieldVisitor(Map<String, Object> ddmFormBuilderContext, Consumer<Map<String, Object>> fieldConsumer) {
            this._ddmFormBuilderContext = ddmFormBuilderContext;
            this._fieldConsumer = fieldConsumer;
        }

        public void visit() {
            this.traversePages((List)this._ddmFormBuilderContext.get("pages"));
        }

        protected void traverseColumns(List<Map<String, Object>> columns) {
            for (Map<String, Object> column : columns) {
                this.traverseFields((List)column.get("fields"));
            }
        }

        protected void traverseFields(List<Map<String, Object>> fields) {
            for (Map<String, Object> field : fields) {
                this._fieldConsumer.accept(field);
                if (!field.containsKey("nestedFields")) continue;
                this.traverseFields((List)field.get("nestedFields"));
            }
        }

        protected void traversePages(List<Map<String, Object>> pages) {
            for (Map<String, Object> page : pages) {
                this.traverseRows((List)page.get("rows"));
            }
        }

        protected void traverseRows(List<Map<String, Object>> rows) {
            for (Map<String, Object> row : rows) {
                this.traverseColumns((List)row.get("columns"));
            }
        }
    }
}

