/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.converter.visitor;

import com.liferay.dynamic.data.mapping.expression.model.AndExpression;
import com.liferay.dynamic.data.mapping.expression.model.ArrayExpression;
import com.liferay.dynamic.data.mapping.expression.model.BinaryExpression;
import com.liferay.dynamic.data.mapping.expression.model.ComparisonExpression;
import com.liferay.dynamic.data.mapping.expression.model.Expression;
import com.liferay.dynamic.data.mapping.expression.model.ExpressionVisitor;
import com.liferay.dynamic.data.mapping.expression.model.FloatingPointLiteral;
import com.liferay.dynamic.data.mapping.expression.model.FunctionCallExpression;
import com.liferay.dynamic.data.mapping.expression.model.IntegerLiteral;
import com.liferay.dynamic.data.mapping.expression.model.NotExpression;
import com.liferay.dynamic.data.mapping.expression.model.OrExpression;
import com.liferay.dynamic.data.mapping.expression.model.StringLiteral;
import com.liferay.dynamic.data.mapping.expression.model.Term;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.DDMFormRuleCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;

public class ConditionExpressionVisitor
extends ExpressionVisitor<Object> {
    private static final Map<String, String> _functionNameOperatorMap = new HashMap<String, String>(){
        {
            this.put("belongsTo", "belongs-to");
            this.put("contains", "contains");
            this.put("equals", "equals-to");
            this.put("isEmpty", "is-empty");
        }
    };
    private static final Map<String, String> _operatorMap = new HashMap<String, String>(){
        {
            this.put("<", "less-than");
            this.put("<=", "less-than-equals");
            this.put(">", "greater-than");
            this.put(">=", "greater-than-equals");
        }
    };
    private boolean _andOperator = true;
    private final Stack<DDMFormRuleCondition> _conditions = new Stack();

    public List<DDMFormRuleCondition> getConditions() {
        return this._conditions;
    }

    public String getLogicalOperator() {
        if (this._andOperator) {
            return "AND";
        }
        return "OR";
    }

    public Object visit(AndExpression andExpression) {
        this._andOperator = true;
        return this.doVisitLogicalExpression((BinaryExpression)andExpression);
    }

    public Object visit(ArrayExpression arrayExpression) {
        String value = arrayExpression.getValue();
        return new DDMFormRuleCondition.Operand("list", value.replaceAll("\\[|\\]|'", ""));
    }

    public Object visit(ComparisonExpression comparisonExpression) {
        DDMFormRuleCondition.Operand leftOperand = (DDMFormRuleCondition.Operand)this.doVisit(comparisonExpression.getLeftOperandExpression());
        DDMFormRuleCondition.Operand rightOperand = (DDMFormRuleCondition.Operand)this.doVisit(comparisonExpression.getRightOperandExpression());
        DDMFormRuleCondition ddmFormRuleCondition = new DDMFormRuleCondition(_operatorMap.get(comparisonExpression.getOperator()), Arrays.asList(leftOperand, rightOperand));
        this._conditions.push(ddmFormRuleCondition);
        return this._conditions;
    }

    public Object visit(FloatingPointLiteral floatingPointLiteral) {
        return new DDMFormRuleCondition.Operand("double", floatingPointLiteral.getValue());
    }

    public Object visit(FunctionCallExpression functionCallExpression) {
        String functionName = functionCallExpression.getFunctionName();
        List parameterExpressions = functionCallExpression.getParameterExpressions();
        if (Objects.equals(functionName, "getJSONValue")) {
            DDMFormRuleCondition.Operand operand = (DDMFormRuleCondition.Operand)this.doVisit((Expression)parameterExpressions.get(0));
            return new DDMFormRuleCondition.Operand("json", operand.getValue());
        }
        if (Objects.equals(functionName, "getValue")) {
            DDMFormRuleCondition.Operand operand = (DDMFormRuleCondition.Operand)this.doVisit((Expression)parameterExpressions.get(0));
            return new DDMFormRuleCondition.Operand("field", operand.getValue());
        }
        ArrayList<DDMFormRuleCondition.Operand> operands = new ArrayList<DDMFormRuleCondition.Operand>();
        for (Expression parameterExpression : parameterExpressions) {
            if (functionCallExpression.hasNestedFunctions()) {
                operands.add(new DDMFormRuleCondition.Operand("condition", parameterExpression.toString()));
                continue;
            }
            operands.add((DDMFormRuleCondition.Operand)this.doVisit(parameterExpression));
        }
        this._conditions.push(this.createDDMFormRuleCondition(functionName, operands));
        return this._conditions;
    }

    public Object visit(IntegerLiteral integerLiteral) {
        return new DDMFormRuleCondition.Operand("integer", integerLiteral.getValue());
    }

    public Object visit(NotExpression notExpression) {
        this.doVisit(notExpression.getOperandExpression());
        DDMFormRuleCondition condition = this._conditions.peek();
        String operator = condition.getOperator();
        condition.setOperator("not-" + operator);
        return this._conditions;
    }

    public Object visit(OrExpression orExpression) {
        this._andOperator = false;
        return this.doVisitLogicalExpression((BinaryExpression)orExpression);
    }

    public Object visit(StringLiteral stringLiteral) {
        return new DDMFormRuleCondition.Operand("string", stringLiteral.getValue());
    }

    public Object visit(Term term) {
        return new DDMFormRuleCondition.Operand("field", term.getValue());
    }

    protected DDMFormRuleCondition createDDMFormRuleCondition(String functionName, List<DDMFormRuleCondition.Operand> operands) {
        String functionNameOperator = _functionNameOperatorMap.get(functionName);
        return new DDMFormRuleCondition(functionNameOperator, operands);
    }

    protected <T> T doVisit(Expression expression) {
        return (T)expression.accept((ExpressionVisitor)this);
    }

    protected List<DDMFormRuleCondition> doVisitLogicalExpression(BinaryExpression binaryExpression) {
        Object o1 = this.doVisit(binaryExpression.getLeftOperandExpression());
        Object o2 = this.doVisit(binaryExpression.getRightOperandExpression());
        if (o1 instanceof DDMFormRuleCondition) {
            this._conditions.push((DDMFormRuleCondition)o1);
        }
        if (o2 instanceof DDMFormRuleCondition) {
            this._conditions.push((DDMFormRuleCondition)o2);
        }
        return this._conditions;
    }
}

