"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.21/js/components/FormBuilder/FormBuilder.es", ['module', 'exports', 'require', '../SuccessPage/SuccessPage.es', 'frontend-taglib-clay$clay-modal', 'frontend-js-metal-web$metal-jsx', 'dynamic-data-mapping-form-renderer/js/util/compose.es', 'frontend-js-metal-web$metal-dom', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormRenderer.es', '../../components/Sidebar/Sidebar.es', './withActionableFields.es', './withEditablePageHeader.es', './withMoveableFields.es', './withMultiplePages.es', './withResizeableColumns.es', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-events', '../../util/config.es', '../LayoutProvider/util/fields.es', 'dynamic-data-mapping-form-renderer/js/util/fetch.es', '../../util/fieldSupport.es', 'dynamic-data-mapping-form-renderer/js/util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.FormBuilderBase = exports.default = void 0;

  require("../SuccessPage/SuccessPage.es");

  var _clayModal = _interopRequireDefault(require("frontend-taglib-clay$clay-modal"));

  var _metalJsx = _interopRequireDefault(require("frontend-js-metal-web$metal-jsx"));

  var _compose = _interopRequireDefault(require("dynamic-data-mapping-form-renderer/js/util/compose.es"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _FormRenderer = _interopRequireDefault(require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormRenderer.es"));

  var _Sidebar = _interopRequireDefault(require("../../components/Sidebar/Sidebar.es"));

  var _withActionableFields = _interopRequireDefault(require("./withActionableFields.es"));

  var _withEditablePageHeader = _interopRequireDefault(require("./withEditablePageHeader.es"));

  var _withMoveableFields = _interopRequireDefault(require("./withMoveableFields.es"));

  var _withMultiplePages = _interopRequireDefault(require("./withMultiplePages.es"));

  var _withResizeableColumns = _interopRequireDefault(require("./withResizeableColumns.es"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  var _config = require("../../util/config.es");

  var _fields = require("../LayoutProvider/util/fields.es");

  var _fetch = require("dynamic-data-mapping-form-renderer/js/util/fetch.es");

  var _fieldSupport = require("../../util/fieldSupport.es");

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};var ownKeys = Object.keys(source);if (typeof Object.getOwnPropertySymbols === 'function') {
        ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        }));
      }ownKeys.forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Builder.
   * @extends Component
   */
  var FormBuilderBase =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FormBuilderBase, _Component);

    function FormBuilderBase() {
      _classCallCheck(this, FormBuilderBase);

      return _possibleConstructorReturn(this, _getPrototypeOf(FormBuilderBase).apply(this, arguments));
    }

    _createClass(FormBuilderBase, [{
      key: "attached",
      value: function attached() {
        var _this = this;

        var _this$props = this.props,
            activePage = _this$props.activePage,
            pages = _this$props.pages;
        var store = this.context.store;
        var formBasicInfo = document.querySelector('.ddm-form-basic-info');
        var translationManager = document.querySelector('.ddm-translation-manager');

        if (formBasicInfo && translationManager) {
          formBasicInfo.classList.remove('hide');
          translationManager.classList.remove('hide');
        }

        if (!this._pageHasFields(pages, activePage)) {
          this.openSidebar();
        }

        this._eventHandler.add(store.on('fieldDuplicated', function () {
          return _this.openSidebar();
        }));
      }
    }, {
      key: "created",
      value: function created() {
        this._eventHandler = new _metalEvents.EventHandler();
        this._handleCancelChangesModalButtonClicked = this._handleCancelChangesModalButtonClicked.bind(this);
      }
    }, {
      key: "disposeInternal",
      value: function disposeInternal() {
        _get(_getPrototypeOf(FormBuilderBase.prototype), "disposeInternal", this).call(this);

        this._eventHandler.removeAllListeners();
      }
    }, {
      key: "getFormRendererEvents",
      value: function getFormRendererEvents() {
        return {
          fieldClicked: this._handleFieldClicked.bind(this)
        };
      }
    }, {
      key: "getSidebarEvents",
      value: function getSidebarEvents() {
        return {
          fieldAdded: this._handleFieldAdded.bind(this),
          fieldBlurred: this._handleSidebarFieldBlurred.bind(this),
          fieldChangesCanceled: this._handleCancelFieldChangesModal.bind(this),
          fieldDeleted: this._handleFieldDeleted.bind(this),
          fieldDuplicated: this._handleFieldDuplicated.bind(this),
          fieldSetAdded: this._handleFieldSetAdded.bind(this),
          settingsFieldBlurred: this._handleSettingsFieldBlurred.bind(this),
          settingsFieldEdited: this._handleSettingsFieldEdited.bind(this)
        };
      }
    }, {
      key: "openSidebar",
      value: function openSidebar() {
        var sidebar = this.refs.sidebar;
        sidebar.open();
      }
    }, {
      key: "preparePagesForRender",
      value: function preparePagesForRender(pages) {
        var visitor = new _visitors.PagesVisitor(pages);
        return visitor.mapFields(function (field) {
          if (field.type === 'select' && field.dataSourceType !== 'manual') {
            field = _objectSpread({}, field, {
              options: [{
                label: Liferay.Language.get('dynamically-loaded-data'),
                value: 'dynamic'
              }],
              value: 'dynamic'
            });
          }

          return _objectSpread({}, field, {
            readOnly: true
          });
        });
      }
    }, {
      key: "render",
      value: function render() {
        var props = this.props;
        var activePage = props.activePage,
            defaultLanguageId = props.defaultLanguageId,
            editingLanguageId = props.editingLanguageId,
            fieldSets = props.fieldSets,
            fieldTypes = props.fieldTypes,
            focusedField = props.focusedField,
            pages = props.pages,
            paginationMode = props.paginationMode,
            portletNamespace = props.portletNamespace,
            rules = props.rules,
            spritemap = props.spritemap,
            visible = props.visible;
        IncrementalDOM.elementOpen("div");
        IncrementalDOM.elementOpen("div", null, null, "class", 'container ddm-form-builder');
        IncrementalDOM.elementOpen("div", null, null, "class", 'sheet');
        IncrementalDOM.elementVoid(_FormRenderer.default, null, null, "activePage", activePage, "editingLanguageId", editingLanguageId, "events", this.getFormRendererEvents(), "pages", this.preparePagesForRender(pages), "paginationMode", paginationMode, "portletNamespace", portletNamespace, "spritemap", spritemap, "editable", true, "ref", 'FormRenderer');
        IncrementalDOM.elementVoid(_clayModal.default, null, null, "body", Liferay.Language.get('are-you-sure-you-want-to-cancel'), "events", {
          clickButton: this._handleCancelChangesModalButtonClicked
        }, "footerButtons", [{
          alignment: 'right',
          label: Liferay.Language.get('dismiss'),
          style: 'primary',
          type: 'close'
        }, {
          alignment: 'right',
          label: Liferay.Language.get('yes-cancel'),
          style: 'primary',
          type: 'button'
        }], "spritemap", spritemap, "title", Liferay.Language.get('cancel-field-changes-question'), "ref", 'cancelChangesModal', "size", 'sm');
        IncrementalDOM.elementClose("div");
        IncrementalDOM.elementClose("div");
        IncrementalDOM.elementVoid(_Sidebar.default, null, null, "defaultLanguageId", defaultLanguageId, "editingLanguageId", editingLanguageId, "events", this.getSidebarEvents(), "fieldSets", fieldSets, "fieldTypes", fieldTypes, "focusedField", focusedField, "portletNamespace", portletNamespace, "rules", rules, "spritemap", spritemap, "visible", visible, "ref", 'sidebar');
        return IncrementalDOM.elementClose("div");
      }
    }, {
      key: "rendered",
      value: function rendered() {
        var sidebar = this.refs.sidebar;
        sidebar.refreshDragAndDrop();
      }
    }, {
      key: "syncEditingLanguageId",
      value: function syncEditingLanguageId(editingLanguageId) {
        var defaultLanguageId = this.props.defaultLanguageId;
        var addButton = document.querySelector('#addFieldButton');

        if (defaultLanguageId === editingLanguageId) {
          addButton.classList.remove('invisible');
        } else {
          addButton.classList.add('invisible');
        }
      }
    }, {
      key: "syncVisible",
      value: function syncVisible(visible) {
        var addButton = document.querySelector('#addFieldButton');
        var translationManager = document.querySelector('.ddm-translation-manager');

        _get(_getPrototypeOf(FormBuilderBase.prototype), "syncVisible", this).call(this, visible);

        if (visible) {
          addButton.classList.remove('hide');
          translationManager.classList.remove('hide');

          this._eventHandler.add(_metalDom.default.on('#addFieldButton', 'click', this._handleAddFieldButtonClicked.bind(this)));
        } else {
          this._eventHandler.removeAllListeners();
        }
      }
    }, {
      key: "willReceiveProps",
      value: function willReceiveProps(changes) {
        var _this$props2 = this.props,
            activePage = _this$props2.activePage,
            pages = _this$props2.pages;
        var openSidebar = false;

        if (changes.activePage && changes.activePage.newVal !== -1) {
          activePage = changes.activePage.newVal;

          if (!this._pageHasFields(pages, activePage)) {
            openSidebar = true;
          }
        }

        if (changes.pages && changes.pages.prevVal && changes.pages.newVal.length !== changes.pages.prevVal.length) {
          pages = changes.pages.newVal;

          if (!this._pageHasFields(pages, activePage)) {
            openSidebar = true;
          }
        }

        if (pages[activePage].successPageSettings) {
          openSidebar = false;
        }

        if (openSidebar) {
          this.openSidebar();
        }
      }
    }, {
      key: "_fetchFieldSet",
      value: function _fetchFieldSet(fieldSetId) {
        var _this$props3 = this.props,
            editingLanguageId = _this$props3.editingLanguageId,
            fieldSetDefinitionURL = _this$props3.fieldSetDefinitionURL,
            groupId = _this$props3.groupId,
            portletNamespace = _this$props3.portletNamespace;
        return (0, _fetch.makeFetch)({
          method: 'GET',
          url: "".concat(fieldSetDefinitionURL, "?ddmStructureId=").concat(fieldSetId, "&languageId=").concat(editingLanguageId, "&portletNamespace=").concat(portletNamespace, "&scopeGroupId=").concat(groupId)
        }).then(function (_ref) {
          var pages = _ref.pages;
          return pages;
        }).catch(function (error) {
          throw new Error(error);
        });
      }
    }, {
      key: "_handleAddFieldButtonClicked",
      value: function _handleAddFieldButtonClicked() {
        this.openSidebar();
      }
    }, {
      key: "_handleCancelChangesModalButtonClicked",
      value: function _handleCancelChangesModalButtonClicked(event) {
        var store = this.context.store;
        event.stopPropagation();
        var target = event.target;
        var _this$refs = this.refs,
            cancelChangesModal = _this$refs.cancelChangesModal,
            sidebar = _this$refs.sidebar;

        if (this._isOutsideModal(target)) {
          sidebar.close();
        }

        cancelChangesModal.emit('hide');

        if (!event.target.classList.contains('close-modal')) {
          store.emit('fieldChangesCanceled', {});
        }
      }
    }, {
      key: "_handleCancelFieldChangesModal",
      value: function _handleCancelFieldChangesModal() {
        var cancelChangesModal = this.refs.cancelChangesModal;
        cancelChangesModal.show();
      }
    }, {
      key: "_handleFieldAdded",
      value: function _handleFieldAdded(event) {
        var dispatch = this.context.dispatch;
        var fieldType = event.fieldType;
        var editingLanguageId = this.props.editingLanguageId;
        var settingsContext = fieldType.settingsContext;
        var pages = settingsContext.pages;
        var newFieldName = (0, _fields.generateFieldName)(this.props.pages, fieldType.label);

        var focusedField = _objectSpread({}, fieldType, {
          fieldName: newFieldName,
          settingsContext: _objectSpread({}, settingsContext, {
            pages: (0, _fieldSupport.normalizeSettingsContextPages)(pages, editingLanguageId, fieldType, newFieldName),
            type: fieldType.name
          })
        });

        var addedToPlaceholder = !event.data.target.parentElement.parentElement.classList.contains('position-relative');
        dispatch('fieldAdded', _objectSpread({}, event, {
          addedToPlaceholder: addedToPlaceholder,
          focusedField: focusedField
        }));
        this.openSidebar();
      }
    }, {
      key: "_handleFieldClicked",
      value: function _handleFieldClicked(event) {
        var dispatch = this.context.dispatch;
        this.openSidebar();
        dispatch('fieldClicked', event);
      }
    }, {
      key: "_handleFieldDeleted",
      value: function _handleFieldDeleted(event) {
        this.emit('fieldDeleted', event);
      }
    }, {
      key: "_handleFieldDuplicated",
      value: function _handleFieldDuplicated(event) {
        this.emit('fieldDuplicated', event);
      }
    }, {
      key: "_handleFieldSetAdded",
      value: function _handleFieldSetAdded(event) {
        var data = event.data;
        var dispatch = this.context.dispatch;
        var fieldSetId = data.source.dataset.fieldSetId;

        this._fetchFieldSet(fieldSetId).then(function (pages) {
          dispatch('fieldSetAdded', _objectSpread({}, event, {
            fieldSetPages: pages
          }));
        });
      }
    }, {
      key: "_handleSettingsFieldBlurred",
      value: function _handleSettingsFieldBlurred(_ref2) {
        var fieldInstance = _ref2.fieldInstance,
            value = _ref2.value;
        var store = this.context.store;
        var editingLanguageId = this.props.editingLanguageId;
        var fieldName = fieldInstance.fieldName;
        store.emit('fieldBlurred', {
          editingLanguageId: editingLanguageId,
          propertyName: fieldName,
          propertyValue: value
        });
      }
    }, {
      key: "_handleSettingsFieldEdited",
      value: function _handleSettingsFieldEdited(_ref3) {
        var fieldInstance = _ref3.fieldInstance,
            value = _ref3.value;

        if (fieldInstance && !fieldInstance.isDisposed()) {
          var editingLanguageId = this.props.editingLanguageId;
          var fieldName = fieldInstance.fieldName;
          var store = this.context.store;
          store.emit('fieldEdited', {
            editingLanguageId: editingLanguageId,
            propertyName: fieldName,
            propertyValue: value
          });
        }
      }
    }, {
      key: "_handleSidebarFieldBlurred",
      value: function _handleSidebarFieldBlurred() {
        var store = this.context.store;
        store.emit('sidebarFieldBlurred');
      }
    }, {
      key: "_isOutsideModal",
      value: function _isOutsideModal(node) {
        return !_metalDom.default.closest(node, '.close-modal');
      }
    }, {
      key: "_pageHasFields",
      value: function _pageHasFields(pages, pageIndex) {
        var visitor = new _visitors.PagesVisitor([pages[pageIndex]]);
        var hasFields = false;
        visitor.mapFields(function () {
          hasFields = true;
        });
        return hasFields;
      }
    }]);

    return FormBuilderBase;
  }(_metalJsx.default);

  exports.FormBuilderBase = FormBuilderBase;
  FormBuilderBase.PROPS = {
    /**
     * @default
     * @instance
     * @memberof FormBuilder
     * @type {?number}
     */
    activePage: _metalState.Config.number().value(0),

    /**
     * @default undefined
     * @instance
     * @memberof FormBuilder
     * @type {?string}
     */
    defaultLanguageId: _metalState.Config.string(),

    /**
     * @default undefined
     * @instance
     * @memberof FormBuilder
     * @type {?string}
     */
    editingLanguageId: _metalState.Config.string(),

    /**
     * @default []
     * @instance
     * @memberof Sidebar
     * @type {?(array|undefined)}
     */
    fieldTypes: _metalState.Config.array().value([]),

    /**
     * @default {}
     * @instance
     * @memberof FormBuilder
     * @type {?object}
     */
    focusedField: _config.focusedFieldStructure.value({}),

    /**
     * @default []
     * @instance
     * @memberof FormBuilder
     * @type {?array<object>}
     */
    pages: _metalState.Config.arrayOf(_config.pageStructure).value([]),

    /**
     * @instance
     * @memberof FormBuilder
     * @type {string}
     */
    paginationMode: _metalState.Config.string().required(),

    /**
     * @instance
     * @memberof FormBuilder
     * @type {string}
     */
    portletNamespace: _metalState.Config.string().required(),

    /**
     * @instance
     * @memberof FormBuilder
     * @type {string}
     */
    rules: _metalState.Config.arrayOf(_config.ruleStructure).required(),

    /**
     * @default undefined
     * @instance
     * @memberof FormRenderer
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required()
  };

  var _default = (0, _compose.default)(_withActionableFields.default, _withEditablePageHeader.default, _withMoveableFields.default, _withMultiplePages.default, _withResizeableColumns.default)(FormBuilderBase);

  exports.default = _default;
  //# sourceMappingURL=FormBuilder.es.js.map
});
//# sourceMappingURL=FormBuilder.es.js.map