/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.servlet;

import com.liferay.dynamic.data.mapping.form.builder.context.DDMFormBuilderContextFactory;
import com.liferay.dynamic.data.mapping.form.builder.context.DDMFormBuilderContextRequest;
import com.liferay.dynamic.data.mapping.form.builder.context.DDMFormBuilderContextResponse;
import com.liferay.dynamic.data.mapping.form.builder.internal.servlet.BaseDDMFormBuilderServlet;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"dynamic.data.mapping.form.builder.servlet=true", "osgi.http.whiteboard.context.path=/dynamic-data-mapping-form-builder-fieldset-definition", "osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMFieldSetDefinitionServlet", "osgi.http.whiteboard.servlet.pattern=/dynamic-data-mapping-form-builder-fieldset-definition/*"}, service={Servlet.class})
public class DDMFieldSetDefinitionServlet
extends BaseDDMFormBuilderServlet {
    private static final Log _log = LogFactoryUtil.getLog(DDMFieldSetDefinitionServlet.class);
    private static final long serialVersionUID = 1L;
    @Reference
    private DDMFormBuilderContextFactory _ddmFormBuilderContextFactory;
    @Reference
    private DDMStructureService _ddmStructureService;
    @Reference
    private JSONFactory _jsonFactory;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        long ddmStructureId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"ddmStructureId");
        if (ddmStructureId == 0L) {
            httpServletResponse.sendError(400);
            return;
        }
        String languageId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"languageId");
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        LocaleThreadLocal.setThemeDisplayLocale((Locale)locale);
        Optional<DDMStructure> ddmStructureOptional = Optional.ofNullable(this.getDDMStructure(ddmStructureId));
        DDMFormBuilderContextResponse fieldContext = this._ddmFormBuilderContextFactory.create(DDMFormBuilderContextRequest.with(ddmStructureOptional, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Locale)locale, (boolean)true));
        httpServletResponse.setContentType("application/json");
        httpServletResponse.setStatus(200);
        JSONSerializer jsonSerializer = this._jsonFactory.createJSONSerializer();
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)jsonSerializer.serializeDeep((Object)fieldContext.getContext()));
    }

    protected DDMStructure getDDMStructure(long ddmStructureId) {
        try {
            return this._ddmStructureService.getStructure(ddmStructureId);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
            return null;
        }
    }
}

