/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.instance.internal;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderException;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.workflow.manager.WorkflowDefinitionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"ddm.data.provider.instance.id=workflow-definitions"}, service={DDMDataProvider.class})
public class WorkflowDefinitionsDataProvider
implements DDMDataProvider {
    protected static final Snapshot<WorkflowDefinitionManager> workflowDefinitionManagerSnapshot = new Snapshot(WorkflowDefinitionsDataProvider.class, WorkflowDefinitionManager.class, null, true);
    @Reference
    private Language _language;

    public DDMDataProviderResponse getData(DDMDataProviderRequest ddmDataProviderRequest) throws DDMDataProviderException {
        ArrayList<KeyValuePair> keyValuePairs = new ArrayList<KeyValuePair>();
        Locale locale = ddmDataProviderRequest.getLocale();
        keyValuePairs.add(new KeyValuePair("no-workflow", this._language.get(locale, "no-workflow")));
        DDMDataProviderResponse.Builder builder = DDMDataProviderResponse.Builder.newBuilder();
        WorkflowDefinitionManager workflowDefinitionManager = (WorkflowDefinitionManager)workflowDefinitionManagerSnapshot.get();
        if (workflowDefinitionManager == null) {
            builder = builder.withOutput("Default-Output", keyValuePairs);
            return builder.build();
        }
        try {
            List workflowDefinitions = workflowDefinitionManager.liberalGetActiveWorkflowDefinitions(ddmDataProviderRequest.getCompanyId(), -1, -1, null);
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            for (WorkflowDefinition workflowDefinition : workflowDefinitions) {
                String value = workflowDefinition.getName();
                keyValuePairs.add(new KeyValuePair(value, workflowDefinition.getTitle(languageId)));
            }
            builder = builder.withOutput("Default-Output", keyValuePairs);
        }
        catch (WorkflowException workflowException) {
            throw new DDMDataProviderException((Throwable)workflowException);
        }
        return builder.build();
    }

    public Class<?> getSettings() {
        throw new UnsupportedOperationException();
    }
}

