/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.impl;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.base.DDLRecordServiceBaseImpl;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ddl", "json.web.service.context.path=DDLRecord"}, service={AopService.class})
public class DDLRecordServiceImpl
extends DDLRecordServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.dynamic.data.lists.model.DDLRecordSet)")
    private ModelResourcePermission<DDLRecordSet> _ddlRecordSetModelResourcePermission;

    public DDLRecord addRecord(long groupId, long recordSetId, int displayIndex, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), recordSetId, "ADD_RECORD");
        return this.ddlRecordLocalService.addRecord(this.getGuestOrUserId(), groupId, recordSetId, displayIndex, ddmFormValues, serviceContext);
    }

    public DDLRecord addRecord(long groupId, long recordSetId, int displayIndex, Map<String, Serializable> fieldsMap, ServiceContext serviceContext) throws PortalException {
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), recordSetId, "ADD_RECORD");
        return this.ddlRecordLocalService.addRecord(this.getGuestOrUserId(), groupId, recordSetId, displayIndex, fieldsMap, serviceContext);
    }

    public void deleteRecord(long recordId) throws PortalException {
        DDLRecord record = this.ddlRecordLocalService.getDDLRecord(recordId);
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), record.getRecordSetId(), "DELETE");
        this.ddlRecordLocalService.deleteRecord(record);
    }

    public DDLRecord getRecord(long recordId) throws PortalException {
        DDLRecord record = this.ddlRecordLocalService.getDDLRecord(recordId);
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), record.getRecordSetId(), "VIEW");
        return record;
    }

    public List<DDLRecord> getRecords(long recordSetId) throws PortalException {
        this._ddlRecordSetModelResourcePermission.contains(this.getPermissionChecker(), recordSetId, "VIEW");
        return this.ddlRecordLocalService.getRecords(recordSetId);
    }

    public void revertRecord(long recordId, String version, ServiceContext serviceContext) throws PortalException {
        DDLRecord record = this.ddlRecordLocalService.getDDLRecord(recordId);
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), record.getRecordSetId(), "UPDATE");
        this.ddlRecordLocalService.revertRecord(this.getGuestOrUserId(), recordId, version, serviceContext);
    }

    public DDLRecord updateRecord(long recordId, boolean majorVersion, int displayIndex, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        DDLRecord record = this.ddlRecordLocalService.getDDLRecord(recordId);
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), record.getRecordSetId(), "UPDATE");
        return this.ddlRecordLocalService.updateRecord(this.getUserId(), recordId, majorVersion, displayIndex, ddmFormValues, serviceContext);
    }

    public DDLRecord updateRecord(long recordId, int displayIndex, Map<String, Serializable> fieldsMap, boolean mergeFields, ServiceContext serviceContext) throws PortalException {
        DDLRecord record = this.ddlRecordLocalService.getDDLRecord(recordId);
        this._ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), record.getRecordSetId(), "UPDATE");
        return this.ddlRecordLocalService.updateRecord(this.getUserId(), recordId, displayIndex, fieldsMap, mergeFields, serviceContext);
    }
}

