/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.search.spi.model.query.contributor;

import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.io.Serializable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.dynamic.data.lists.model.DDLRecord"}, service={ModelPreFilterContributor.class})
public class DDLRecordModelPreFilterContributor
implements ModelPreFilterContributor {
    @Reference
    protected DDMIndexer ddmIndexer;
    private static final Log _log = LogFactoryUtil.getLog(DDLRecordModelPreFilterContributor.class);

    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        block5: {
            long recordSetId;
            int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
            if (status != -1) {
                booleanFilter.addRequiredTerm("status", status);
            }
            if ((recordSetId = GetterUtil.getLong((Object)searchContext.getAttribute("recordSetId"))) > 0L) {
                booleanFilter.addRequiredTerm("recordSetId", recordSetId);
            }
            long recordSetScope = GetterUtil.getLong((Object)searchContext.getAttribute("recordSetScope"), (long)0L);
            booleanFilter.addRequiredTerm("recordSetScope", recordSetScope);
            this._addSearchClassTypeIds(booleanFilter, searchContext);
            String ddmStructureFieldName = (String)((Object)searchContext.getAttribute("ddmStructureFieldName"));
            Serializable ddmStructureFieldValue = searchContext.getAttribute("ddmStructureFieldValue");
            if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
                try {
                    QueryFilter queryFilter = this.ddmIndexer.createFieldValueQueryFilter(ddmStructureFieldName, ddmStructureFieldValue, searchContext.getLocale());
                    booleanFilter.add((Filter)queryFilter, BooleanClauseOccur.MUST);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block5;
                    _log.debug((Throwable)exception);
                }
            }
        }
    }

    private Filter _addSearchClassTypeIds(BooleanFilter contextBooleanFilter, SearchContext searchContext) {
        long[] classTypeIds = searchContext.getClassTypeIds();
        if (ArrayUtil.isEmpty((long[])classTypeIds)) {
            return null;
        }
        TermsFilter termsFilter = new TermsFilter("classTypeId");
        termsFilter.addValues(ArrayUtil.toStringArray((long[])classTypeIds));
        return contextBooleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST);
    }
}

