/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.exporter;

import com.liferay.dynamic.data.lists.exporter.DDLExporter;
import com.liferay.dynamic.data.lists.exporter.DDLExporterFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={DDLExporterFactory.class})
public class DDLExporterFactoryImpl
implements DDLExporterFactory {
    private ServiceTrackerMap<String, DDLExporter> _serviceTrackerMap;

    public DDLExporter getDDLExporter(String format) {
        DDLExporter ddlExporter = (DDLExporter)this._serviceTrackerMap.getService((Object)format);
        if (ddlExporter == null) {
            throw new IllegalArgumentException("No DDL exporter exists for the format " + format);
        }
        return ddlExporter;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DDLExporter.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (ddlExporter, emitter) -> emitter.emit((Object)ddlExporter.getFormat())));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

