/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.exporter;

import com.liferay.dynamic.data.lists.exporter.DDLExporter;
import com.liferay.dynamic.data.lists.internal.exporter.BaseDDLExporter;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetVersionService;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldValueRendererRegistry;
import com.liferay.dynamic.data.mapping.storage.DDMStorageEngineManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.CSVUtil;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDLExporter.class})
public class DDLCSVExporter
extends BaseDDLExporter {
    @Reference
    private DDLRecordLocalService _ddlRecordLocalService;
    @Reference
    private DDLRecordSetService _ddlRecordSetService;
    @Reference
    private DDLRecordSetVersionService _ddlRecordSetVersionService;
    @Reference
    private DDMFormFieldTypeServicesRegistry _ddmFormFieldTypeServicesRegistry;
    @Reference
    private DDMFormFieldValueRendererRegistry _ddmFormFieldValueRendererRegistry;
    @Reference
    private DDMStorageEngineManager _ddmStorageEngineManager;
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private Language _language;

    public String getFormat() {
        return "csv";
    }

    @Override
    protected byte[] doExport(long recordSetId, int status, int start, int end, OrderByComparator<DDLRecord> orderByComparator) throws Exception {
        StringBundler sb = new StringBundler();
        DDLRecordSet recordSet = this._ddlRecordSetService.getRecordSet(recordSetId);
        Map<String, DDMFormField> ddmFormFields = this.getDistinctFields(recordSetId);
        Locale locale = this.getLocale();
        for (DDMFormField ddmFormField : ddmFormFields.values()) {
            LocalizedValue label = ddmFormField.getLabel();
            sb.append(CSVUtil.encode((String)label.getString(locale)));
            sb.append(',');
        }
        sb.append(this._language.get(locale, "status"));
        sb.append(',');
        sb.append(this._language.get(locale, "modified-date"));
        sb.append(',');
        sb.append(this._language.get(locale, "author"));
        sb.append("\n");
        List records = this._ddlRecordLocalService.getRecords(recordSetId, status, start, end, orderByComparator);
        Iterator iterator = records.iterator();
        DateTimeFormatter dateTimeFormatter = this.getDateTimeFormatter();
        while (iterator.hasNext()) {
            DDLRecord record = (DDLRecord)iterator.next();
            DDLRecordVersion recordVersion = record.getRecordVersion();
            Map<String, BaseDDLExporter.DDMFormFieldRenderedValue> values = this.getRenderedValues(recordSet.getScope(), ddmFormFields.values(), this._ddmStorageEngineManager.getDDMFormValues(recordVersion.getDDMStorageId()), this._htmlParser);
            for (Map.Entry<String, DDMFormField> entry : ddmFormFields.entrySet()) {
                if (values.containsKey(entry.getKey())) {
                    BaseDDLExporter.DDMFormFieldRenderedValue ddmFormFieldRenderedValue = values.get(entry.getKey());
                    sb.append(CSVUtil.encode((String)ddmFormFieldRenderedValue.getValue()));
                } else {
                    sb.append("");
                }
                sb.append(',');
            }
            sb.append(this.getStatusMessage(recordVersion.getStatus()));
            sb.append(',');
            sb.append(this.formatDate(recordVersion.getStatusDate(), dateTimeFormatter));
            sb.append(',');
            sb.append(CSVUtil.encode((String)recordVersion.getUserName()));
            if (!iterator.hasNext()) continue;
            sb.append("\n");
        }
        String csv = sb.toString();
        return csv.getBytes();
    }

    @Override
    protected DDLRecordSetVersionService getDDLRecordSetVersionService() {
        return this._ddlRecordSetVersionService;
    }

    @Override
    protected DDMFormFieldTypeServicesRegistry getDDMFormFieldTypeServicesRegistry() {
        return this._ddmFormFieldTypeServicesRegistry;
    }

    @Override
    protected DDMFormFieldValueRendererRegistry getDDMFormFieldValueRendererRegistry() {
        return this._ddmFormFieldValueRendererRegistry;
    }
}

