/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.impl;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.base.DDLRecordSetServiceBaseImpl;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDLRecordSetServiceImpl
extends DDLRecordSetServiceBaseImpl {
    private static volatile ModelResourcePermission<DDLRecordSet> _ddlRecordSetModelResourcePermission = ModelResourcePermissionFactory.getInstance(DDLRecordSetServiceImpl.class, (String)"_ddlRecordSetModelResourcePermission", DDLRecordSet.class);
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(DDLRecordSetServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.dynamic.data.lists");

    public DDLRecordSet addRecordSet(long groupId, long ddmStructureId, String recordSetKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, int scope, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_RECORD_SET");
        return this.ddlRecordSetLocalService.addRecordSet(this.getUserId(), groupId, ddmStructureId, recordSetKey, nameMap, descriptionMap, minDisplayRows, scope, serviceContext);
    }

    public void deleteRecordSet(long recordSetId) throws PortalException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        _ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)recordSet, "DELETE");
        this.ddlRecordSetLocalService.deleteRecordSet(recordSet);
    }

    public DDLRecordSet fetchRecordSet(long recordSetId) throws PortalException {
        DDLRecordSet recordSet = this.ddlRecordSetLocalService.fetchRecordSet(recordSetId);
        if (recordSet == null) {
            return null;
        }
        _ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)recordSet, "VIEW");
        return recordSet;
    }

    public DDLRecordSet getRecordSet(long recordSetId) throws PortalException {
        _ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), recordSetId, "VIEW");
        return this.ddlRecordSetLocalService.getRecordSet(recordSetId);
    }

    public List<DDLRecordSet> getRecordSets(long[] groupIds) {
        return this.ddlRecordSetPersistence.filterFindByGroupId(groupIds);
    }

    public List<DDLRecordSet> search(long companyId, long groupId, String keywords, int scope, int start, int end, OrderByComparator<DDLRecordSet> orderByComparator) {
        return this.ddlRecordSetFinder.filterFindByKeywords(companyId, groupId, keywords, scope, start, end, orderByComparator);
    }

    public List<DDLRecordSet> search(long companyId, long groupId, String name, String description, int scope, boolean andOperator, int start, int end, OrderByComparator<DDLRecordSet> orderByComparator) {
        return this.ddlRecordSetFinder.filterFindByC_G_N_D_S(companyId, groupId, name, description, scope, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long groupId, String keywords, int scope) {
        return this.ddlRecordSetFinder.filterCountByKeywords(companyId, groupId, keywords, scope);
    }

    public int searchCount(long companyId, long groupId, String name, String description, int scope, boolean andOperator) {
        return this.ddlRecordSetFinder.filterCountByC_G_N_D_S(companyId, groupId, name, description, scope, andOperator);
    }

    public DDLRecordSet updateMinDisplayRows(long recordSetId, int minDisplayRows, ServiceContext serviceContext) throws PortalException {
        _ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), recordSetId, "UPDATE");
        return this.ddlRecordSetLocalService.updateMinDisplayRows(recordSetId, minDisplayRows, serviceContext);
    }

    public DDLRecordSet updateRecordSet(long recordSetId, DDMFormValues settingsDDMFormValues) throws PortalException {
        _ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), recordSetId, "UPDATE");
        return this.ddlRecordSetLocalService.updateRecordSet(recordSetId, settingsDDMFormValues);
    }

    public DDLRecordSet updateRecordSet(long recordSetId, long ddmStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, ServiceContext serviceContext) throws PortalException {
        _ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), recordSetId, "UPDATE");
        return this.ddlRecordSetLocalService.updateRecordSet(recordSetId, ddmStructureId, nameMap, descriptionMap, minDisplayRows, serviceContext);
    }

    public DDLRecordSet updateRecordSet(long groupId, long ddmStructureId, String recordSetKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, ServiceContext serviceContext) throws PortalException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByG_R(groupId, recordSetKey);
        _ddlRecordSetModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)recordSet, "UPDATE");
        return this.ddlRecordSetLocalService.updateRecordSet(groupId, ddmStructureId, recordSetKey, nameMap, descriptionMap, minDisplayRows, serviceContext);
    }
}

