/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.lists.internal.upgrade.v1_0_1;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.upgrade.AutoBatchPreparedStatementUtil;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

/**
 * @author Pedro Queiroz
 */
public class UpgradeRecordGroup extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		StringBundler sb = new StringBundler(4);

		sb.append("select DDLRecordSet.groupId, DDLRecord.recordId from ");
		sb.append("DDLRecord inner join DDLRecordSet on ");
		sb.append("DDLRecord.recordSetId = DDLRecordSet.recordSetId where ");
		sb.append("DDLRecord.groupId != DDLRecordSet.groupId");

		try (PreparedStatement ps1 = connection.prepareStatement(sb.toString());
			ResultSet rs = ps1.executeQuery();
			PreparedStatement ps2 =
				AutoBatchPreparedStatementUtil.concurrentAutoBatch(
					connection,
					"update DDLRecord set groupId = ? where recordId = ?")) {

			while (rs.next()) {
				long groupId = rs.getLong("groupId");
				long recordId = rs.getLong("recordId");

				ps2.setLong(1, groupId);
				ps2.setLong(2, recordId);

				ps2.addBatch();
			}

			ps2.executeBatch();
		}
	}

}