/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.lists.internal.model.listener;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordSetConstants;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.staging.model.listener.StagingModelListener;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Akos Thurzo
 */
@Component(immediate = true, service = ModelListener.class)
public class DDLRecordStagingModelListener
	extends BaseModelListener<DDLRecord> {

	@Override
	public void onAfterCreate(DDLRecord ddlRecord)
		throws ModelListenerException {

		if (_isSkipEvent(ddlRecord)) {
			return;
		}

		_stagingModelListener.onAfterCreate(ddlRecord);
	}

	@Override
	public void onAfterRemove(DDLRecord ddlRecord)
		throws ModelListenerException {

		_stagingModelListener.onAfterRemove(ddlRecord);
	}

	@Override
	public void onAfterUpdate(DDLRecord ddlRecord)
		throws ModelListenerException {

		if (_isSkipEvent(ddlRecord)) {
			return;
		}

		_stagingModelListener.onAfterUpdate(ddlRecord);
	}

	private boolean _isSkipEvent(DDLRecord ddlRecord) {
		try {
			DDLRecordSet recordSet = ddlRecord.getRecordSet();

			if (recordSet.getScope() !=
					DDLRecordSetConstants.SCOPE_DYNAMIC_DATA_LISTS) {

				return true;
			}
		}
		catch (PortalException pe) {
			if (_log.isDebugEnabled()) {
				_log.debug(pe, pe);
			}
		}

		return false;
	}

	private static final Log _log = LogFactoryUtil.getLog(
		DDLRecordStagingModelListener.class);

	@Reference
	private StagingModelListener<DDLRecord> _stagingModelListener;

}