/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.lists.internal.model.listener;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordSetConstants;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.staging.model.listener.StagingModelListener;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Akos Thurzo
 */
@Component(immediate = true, service = ModelListener.class)
public class DDLRecordSetStagingModelListener
	extends BaseModelListener<DDLRecordSet> {

	@Override
	public void onAfterCreate(DDLRecordSet ddlRecordSet)
		throws ModelListenerException {

		if (_isSkipEvent(ddlRecordSet)) {
			return;
		}

		_stagingModelListener.onAfterCreate(ddlRecordSet);
	}

	@Override
	public void onAfterRemove(DDLRecordSet ddlRecordSet)
		throws ModelListenerException {

		_stagingModelListener.onAfterRemove(ddlRecordSet);
	}

	@Override
	public void onAfterUpdate(DDLRecordSet ddlRecordSet)
		throws ModelListenerException {

		if (_isSkipEvent(ddlRecordSet)) {
			return;
		}

		_stagingModelListener.onAfterUpdate(ddlRecordSet);
	}

	private boolean _isSkipEvent(DDLRecordSet ddlRecordSet) {
		if (ddlRecordSet.getScope() !=
				DDLRecordSetConstants.SCOPE_DYNAMIC_DATA_LISTS) {

			return true;
		}

		return false;
	}

	@Reference
	private StagingModelListener<DDLRecordSet> _stagingModelListener;

}