/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.exporter.impl;

import com.liferay.dynamic.data.lists.exporter.DDLExporter;
import com.liferay.dynamic.data.lists.exporter.impl.BaseDDLExporter;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDLExporter.class})
public class DDLXMLExporter
extends BaseDDLExporter {
    private DDLRecordLocalService _ddlRecordLocalService;
    private DDLRecordSetService _ddlRecordSetService;
    private DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    private StorageEngine _storageEngine;

    public String getFormat() {
        return "xml";
    }

    protected void addFieldElement(Element fieldsElement, String label, Serializable value) {
        Element fieldElement = fieldsElement.addElement("field");
        Element labelElement = fieldElement.addElement("label");
        labelElement.addText(label);
        Element valueElement = fieldElement.addElement("value");
        valueElement.addText(String.valueOf(value));
    }

    @Override
    protected byte[] doExport(long recordSetId, int status, int start, int end, OrderByComparator<DDLRecord> orderByComparator) throws Exception {
        DDLRecordSet recordSet = this._ddlRecordSetService.getRecordSet(recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        List<DDMFormField> ddmFormFields = this.getDDMFormFields(ddmStructure);
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        List records = this._ddlRecordLocalService.getRecords(recordSetId, status, start, end, orderByComparator);
        for (DDLRecord record : records) {
            Element fieldsElement = rootElement.addElement("fields");
            DDLRecordVersion recordVersion = record.getRecordVersion();
            DDMFormValues ddmFormValues = this._storageEngine.getDDMFormValues(recordVersion.getDDMStorageId());
            Fields fields = this._ddmFormValuesToFieldsConverter.convert(ddmStructure, ddmFormValues);
            for (DDMFormField ddmFormField : ddmFormFields) {
                LocalizedValue label = ddmFormField.getLabel();
                String name = ddmFormField.getName();
                String value = "";
                if (fields.contains(name)) {
                    Field field = fields.get(name);
                    value = field.getRenderedValue(this.getLocale());
                }
                this.addFieldElement(fieldsElement, label.getString(this.getLocale()), (Serializable)((Object)value));
            }
            this.addFieldElement(fieldsElement, LanguageUtil.get((Locale)this.getLocale(), (String)"status"), (Serializable)((Object)this.getStatusMessage(recordVersion.getStatus())));
        }
        String xml = document.asXML();
        return xml.getBytes();
    }

    @Reference(unbind="-")
    protected void setDDLRecordLocalService(DDLRecordLocalService ddlRecordLocalService) {
        this._ddlRecordLocalService = ddlRecordLocalService;
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetService(DDLRecordSetService ddlRecordSetService) {
        this._ddlRecordSetService = ddlRecordSetService;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesToFieldsConverter(DDMFormValuesToFieldsConverter ddmFormValuesToFieldsConverter) {
        this._ddmFormValuesToFieldsConverter = ddmFormValuesToFieldsConverter;
    }

    @Reference(unbind="-")
    protected void setStorageEngine(StorageEngine storageEngine) {
        this._storageEngine = storageEngine;
    }
}

