/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search.spi.model.index.contributor;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderTable;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageTable;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentHelper;
import com.liferay.portal.kernel.search.ReindexCacheThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={ModelDocumentContributor.class})
public class DLFileEntryRelatedEntryModelDocumentContributor
implements ModelDocumentContributor<DLFileEntry> {
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private Portal _portal;

    public void contribute(Document document, DLFileEntry dlFileEntry) {
        if (!dlFileEntry.isInHiddenFolder()) {
            return;
        }
        long[] mbMessageValues = this._getMBMessageValues(dlFileEntry.getFolderId());
        if (mbMessageValues != null) {
            document.addKeyword("categoryId", mbMessageValues[0]);
            document.addKeyword("discussion", false);
            document.addKeyword("threadId", mbMessageValues[1]);
        }
        DocumentHelper documentHelper = new DocumentHelper(document);
        documentHelper.setAttachmentOwnerKey(this._portal.getClassNameId(dlFileEntry.getClassName()), dlFileEntry.getClassPK());
        document.addKeyword("relatedEntry", true);
    }

    private long[] _getMBMessageValues(long dlFolderId) {
        Map mbMessageValuesMap = (Map)ReindexCacheThreadLocal.getGlobalReindexCache(() -> -1, (String)DLFileEntryRelatedEntryModelDocumentContributor.class.getName(), count -> {
            JoinStep dslQuery = DSLQueryFactoryUtil.select((Expression[])new Expression[]{DLFolderTable.INSTANCE.folderId, MBMessageTable.INSTANCE.categoryId, MBMessageTable.INSTANCE.threadId}).from((Table)DLFolderTable.INSTANCE).innerJoinON((Table)MBMessageTable.INSTANCE, DLFolderTable.INSTANCE.name.eq(DSLFunctionFactoryUtil.castText((Expression)MBMessageTable.INSTANCE.messageId)));
            List valuesList = (List)this._dlFolderLocalService.dslQuery((DSLQuery)dslQuery, false);
            if (valuesList.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<Long, long[]> localMBMessageValuesMap = new HashMap<Long, long[]>();
            for (Object[] values : valuesList) {
                localMBMessageValuesMap.put((Long)values[0], new long[]{(Long)values[1], (Long)values[2]});
            }
            return localMBMessageValuesMap;
        });
        if (mbMessageValuesMap == null) {
            DLFolder dlFolder = this._dlFolderLocalService.fetchDLFolder(dlFolderId);
            if (dlFolder == null) {
                return null;
            }
            long messageId = GetterUtil.getLong((String)dlFolder.getName());
            if (messageId == 0L) {
                return null;
            }
            MBMessage mbMessage = this._mbMessageLocalService.fetchMBMessage(messageId);
            if (mbMessage == null) {
                return null;
            }
            return new long[]{mbMessage.getCategoryId(), mbMessage.getThreadId()};
        }
        return (long[])mbMessageValuesMap.get(dlFolderId);
    }
}

