/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.util.DLAssetHelper;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import java.io.Serializable;
import java.util.Map;

public class FileEntryAssetEntryBulkSelection
implements BulkSelection<AssetEntry> {
    private final AssetEntryLocalService _assetEntryLocalService;
    private final DLAssetHelper _dlAssetHelper;
    private final BulkSelection<FileEntry> _fileEntryBulkSelection;

    public FileEntryAssetEntryBulkSelection(BulkSelection<FileEntry> fileEntryBulkSelection, AssetEntryLocalService assetEntryLocalService, DLAssetHelper dlAssetHelper) {
        this._fileEntryBulkSelection = fileEntryBulkSelection;
        this._assetEntryLocalService = assetEntryLocalService;
        this._dlAssetHelper = dlAssetHelper;
    }

    public <E extends PortalException> void forEach(UnsafeConsumer<AssetEntry, E> unsafeConsumer) throws PortalException {
        this._fileEntryBulkSelection.forEach(fileEntry -> unsafeConsumer.accept((Object)this._toAssetEntry((FileEntry)fileEntry)));
    }

    public Class<? extends BulkSelectionFactory> getBulkSelectionFactoryClass() {
        return this._fileEntryBulkSelection.getBulkSelectionFactoryClass();
    }

    public Map<String, String[]> getParameterMap() {
        return this._fileEntryBulkSelection.getParameterMap();
    }

    public long getSize() throws PortalException {
        return this._fileEntryBulkSelection.getSize();
    }

    public Serializable serialize() {
        return this._fileEntryBulkSelection.serialize();
    }

    public BulkSelection<AssetEntry> toAssetEntryBulkSelection() {
        return this;
    }

    private AssetEntry _toAssetEntry(FileEntry fileEntry) {
        try {
            return this._assetEntryLocalService.getEntry(DLFileEntryConstants.getClassName(), this._dlAssetHelper.getAssetClassPK(fileEntry, fileEntry.getLatestFileVersion()));
        }
        catch (PortalException portalException) {
            return (AssetEntry)ReflectionUtil.throwException((Throwable)portalException);
        }
    }
}

