/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search.spi.model.index.contributor;

import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.index.contributor.helper.IndexerWriterMode;
import com.liferay.portal.search.spi.model.index.contributor.helper.ModelIndexerWriterDocumentHelper;

public class DLFileEntryModelIndexerWriterContributor
implements ModelIndexerWriterContributor<DLFileEntry> {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryModelIndexerWriterContributor.class);
    private final DLFileEntryLocalService _dlFileEntryLocalService;
    private final DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;

    public DLFileEntryModelIndexerWriterContributor(DLFileEntryLocalService dlFileEntryLocalService, DynamicQueryBatchIndexingActionableFactory dynamicQueryBatchIndexingActionableFactory) {
        this._dlFileEntryLocalService = dlFileEntryLocalService;
        this._dynamicQueryBatchIndexingActionableFactory = dynamicQueryBatchIndexingActionableFactory;
    }

    public void customize(BatchIndexingActionable batchIndexingActionable, ModelIndexerWriterDocumentHelper modelIndexerWriterDocumentHelper) {
        batchIndexingActionable.setPerformActionMethod(dlFileEntry -> batchIndexingActionable.addDocuments(new Document[]{modelIndexerWriterDocumentHelper.getDocument((BaseModel)dlFileEntry)}));
    }

    public BatchIndexingActionable getBatchIndexingActionable() {
        return this._dynamicQueryBatchIndexingActionableFactory.getBatchIndexingActionable(this._dlFileEntryLocalService.getIndexableActionableDynamicQuery());
    }

    public long getCompanyId(DLFileEntry dlFileEntry) {
        return dlFileEntry.getCompanyId();
    }

    public IndexerWriterMode getIndexerWriterMode(DLFileEntry dlFileEntry) {
        DLFileVersion dlFileVersion = null;
        try {
            dlFileVersion = dlFileEntry.getFileVersion();
        }
        catch (NoSuchFileVersionException noSuchFileVersionException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get file version for file entry " + dlFileEntry.getFileEntryId()), (Throwable)noSuchFileVersionException);
            }
            return IndexerWriterMode.SKIP;
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
        if (!(dlFileEntry.isInTrash() || dlFileVersion.isApproved() || dlFileVersion.isExpired())) {
            return IndexerWriterMode.SKIP;
        }
        return IndexerWriterMode.UPDATE;
    }
}

