/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.configuration.helper;

import com.liferay.document.library.configuration.DLFileEntryConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import java.util.Dictionary;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.configuration.DLFileEntryConfiguration"}, service={DLFileEntryConfigurationHelper.class})
public class DLFileEntryConfigurationHelper {
    private final Map<Long, DLFileEntryConfiguration> _companyConfigurationBeans = new ConcurrentHashMap<Long, DLFileEntryConfiguration>();
    private final Map<String, Long> _companyIds = new ConcurrentHashMap<String, Long>();
    private final Map<Long, DLFileEntryConfiguration> _groupConfigurationBeans = new ConcurrentHashMap<Long, DLFileEntryConfiguration>();
    private final Map<String, Long> _groupIds = new ConcurrentHashMap<String, Long>();
    @Reference
    private GroupLocalService _groupLocalService;
    private volatile DLFileEntryConfiguration _systemDLFileEntryConfiguration;

    public int getCompanyMaxNumberOfPages(long companyId) {
        DLFileEntryConfiguration dlFileEntryConfiguration = this._getCompanyDLFileEntryConfiguration(companyId);
        return dlFileEntryConfiguration.maxNumberOfPages();
    }

    public long getCompanyPreviewableProcessorMaxSize(long companyId) {
        DLFileEntryConfiguration dlFileEntryConfiguration = this._getCompanyDLFileEntryConfiguration(companyId);
        return dlFileEntryConfiguration.previewableProcessorMaxSize();
    }

    public Set<Long> getGroupIds() {
        return this._groupConfigurationBeans.keySet();
    }

    public int getGroupMaxNumberOfPages(long groupId) {
        DLFileEntryConfiguration dlFileEntryConfiguration = this._getGroupDLFileEntryConfiguration(groupId);
        return dlFileEntryConfiguration.maxNumberOfPages();
    }

    public long getGroupPreviewableProcessorMaxSize(long groupId) {
        DLFileEntryConfiguration dlFileEntryConfiguration = this._getGroupDLFileEntryConfiguration(groupId);
        return dlFileEntryConfiguration.previewableProcessorMaxSize();
    }

    public int getSystemMaxNumberOfPages() {
        return this._systemDLFileEntryConfiguration.maxNumberOfPages();
    }

    public long getSystemPreviewableProcessorMaxSize() {
        return this._systemDLFileEntryConfiguration.previewableProcessorMaxSize();
    }

    public void unmapPid(String pid) {
        if (this._companyIds.containsKey(pid)) {
            long companyId = this._companyIds.remove(pid);
            this._companyConfigurationBeans.remove(companyId);
            this._groupConfigurationBeans.clear();
            this._groupIds.clear();
        } else if (this._groupIds.containsKey(pid)) {
            long groupId = this._groupIds.remove(pid);
            this._groupConfigurationBeans.remove(groupId);
        }
    }

    public void updateCompanyConfiguration(long companyId, String pid, Dictionary<String, ?> dictionary) {
        this._companyConfigurationBeans.put(companyId, (DLFileEntryConfiguration)ConfigurableUtil.createConfigurable(DLFileEntryConfiguration.class, dictionary));
        this._companyIds.put(pid, companyId);
    }

    public void updateGroupConfiguration(long groupId, String pid, Dictionary<String, ?> dictionary) {
        this._groupConfigurationBeans.put(groupId, (DLFileEntryConfiguration)ConfigurableUtil.createConfigurable(DLFileEntryConfiguration.class, dictionary));
        this._groupIds.put(pid, groupId);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._systemDLFileEntryConfiguration = (DLFileEntryConfiguration)ConfigurableUtil.createConfigurable(DLFileEntryConfiguration.class, properties);
    }

    private DLFileEntryConfiguration _getCompanyDLFileEntryConfiguration(long companyId) {
        return this._getDLFileEntryConfiguration(companyId, this._companyConfigurationBeans, () -> this._systemDLFileEntryConfiguration);
    }

    private DLFileEntryConfiguration _getDLFileEntryConfiguration(long key, Map<Long, DLFileEntryConfiguration> configurationBeans, Supplier<DLFileEntryConfiguration> supplier) {
        if (configurationBeans.containsKey(key)) {
            return configurationBeans.get(key);
        }
        return supplier.get();
    }

    private DLFileEntryConfiguration _getGroupDLFileEntryConfiguration(long groupId) {
        return this._getDLFileEntryConfiguration(groupId, this._groupConfigurationBeans, () -> {
            Group group = this._groupLocalService.fetchGroup(groupId);
            long companyId = CompanyThreadLocal.getCompanyId();
            if (group != null) {
                companyId = group.getCompanyId();
            }
            return this._getCompanyDLFileEntryConfiguration(companyId);
        });
    }
}

