/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.versioning;

import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.versioning.VersioningPolicy;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=100"}, service={VersioningPolicy.class})
public class ContentVersioningPolicy
implements VersioningPolicy {
    private static final Log _log = LogFactoryUtil.getLog(ContentVersioningPolicy.class);
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;

    public DLVersionNumberIncrease computeDLVersionNumberIncrease(DLFileVersion previousDLFileVersion, DLFileVersion nextDLFileVersion) {
        long previousSize = previousDLFileVersion.getSize();
        long nextSize = nextDLFileVersion.getSize();
        if (previousSize == 0L && nextSize >= 0L) {
            return null;
        }
        if (previousSize != nextSize) {
            return DLVersionNumberIncrease.MAJOR;
        }
        String previousChecksum = this._computeChecksum(previousDLFileVersion);
        if (previousChecksum == null) {
            return null;
        }
        String nextChecksum = this._computeChecksum(nextDLFileVersion);
        if (nextChecksum == null || previousChecksum.equals(nextChecksum)) {
            return null;
        }
        return DLVersionNumberIncrease.MAJOR;
    }

    private String _computeChecksum(DLFileVersion dlFileVersion) {
        String string;
        block10: {
            if (Validator.isNotNull((String)dlFileVersion.getChecksum())) {
                return dlFileVersion.getChecksum();
            }
            InputStream inputStream = dlFileVersion.getContentStream(false);
            try {
                dlFileVersion.setChecksum(DigesterUtil.digestBase64((InputStream)inputStream));
                dlFileVersion = this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
                string = dlFileVersion.getChecksum();
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PortalException | IOException exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn(exception);
                    }
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }
}

