/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection.action;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.util.AssetHelper;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"bulk.selection.action.key=edit.tags"}, service={BulkSelectionAction.class})
public class EditTagsBulkSelectionAction
implements BulkSelectionAction<AssetEntry> {
    private static final Log _log = LogFactoryUtil.getLog(EditTagsBulkSelectionAction.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetHelper _assetHelper;

    public void execute(User user, BulkSelection<AssetEntry> bulkSelection, Map<String, Serializable> inputMap) throws Exception {
        Set<String> toAddTagNames = this._toStringSet(inputMap, "toAddTagNames");
        Set<String> toRemoveTagNames = this._toStringSet(inputMap, "toRemoveTagNames");
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        bulkSelection.forEach(assetEntry -> {
            block5: {
                try {
                    if (!this._hasEditPermission((AssetEntry)assetEntry, permissionChecker)) {
                        return;
                    }
                    String[] newTagNames = new String[]{};
                    if (SetUtil.isNotEmpty((Set)toAddTagNames)) {
                        newTagNames = (String[])inputMap.get("toAddTagNames");
                    }
                    if (MapUtil.getBoolean((Map)inputMap, (String)"append")) {
                        Set currentTagNames = SetUtil.fromArray((Object[])assetEntry.getTagNames());
                        currentTagNames.removeAll(toRemoveTagNames);
                        currentTagNames.addAll(toAddTagNames);
                        currentTagNames.removeIf(tagName -> !this._assetHelper.isValidWord(tagName));
                        newTagNames = currentTagNames.toArray(new String[0]);
                    }
                    this._assetEntryLocalService.updateEntry(assetEntry.getUserId(), assetEntry.getGroupId(), assetEntry.getClassName(), assetEntry.getClassPK(), assetEntry.getCategoryIds(), newTagNames);
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Throwable)portalException);
                }
            }
        });
    }

    private boolean _hasEditPermission(AssetEntry assetEntry, PermissionChecker permissionChecker) throws PortalException {
        AssetRenderer assetRenderer = assetEntry.getAssetRenderer();
        if (assetRenderer != null) {
            return assetRenderer.hasEditPermission(permissionChecker);
        }
        return ModelResourcePermissionUtil.contains((PermissionChecker)permissionChecker, (long)assetEntry.getGroupId(), (String)assetEntry.getClassName(), (long)assetEntry.getClassPK(), (String)"UPDATE");
    }

    private Set<String> _toStringSet(Map<String, Serializable> map, String key) {
        try {
            return SetUtil.fromArray((Object[])((String[])map.getOrDefault(key, (Serializable)new String[0])));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return SetUtil.fromArray((Object[])new String[0]);
        }
    }
}

