/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.instance.lifecycle;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.internal.util.DDMFormUtil;
import com.liferay.document.library.kernel.processor.RawMetadataProcessor;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.osgi.util.configuration.ConfigurationPersistenceUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.metadata.RawMetadataProcessorUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, service={PortalInstanceLifecycleListener.class})
public class AddDefaultDocumentLibraryStructuresPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    @Reference
    private DDM _ddm;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    private volatile DLConfiguration _dlConfiguration;
    @Reference
    private GroupLocalService _groupLocalService;
    private long _lastModifiedTime;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public long getLastModifiedTime() {
        return this._lastModifiedTime;
    }

    public void portalInstanceRegistered(Company company) throws Exception {
        if (!this._dlConfiguration.addDefaultStructures()) {
            return;
        }
        this._addDLRawMetadataStructures(company.getCompanyId());
    }

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        this._lastModifiedTime = ConfigurationPersistenceUtil.update((Object)((Object)this), properties);
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
    }

    private void _addDLRawMetadataStructures(long companyId) throws Exception {
        String name = "TIKARAWMETADATA";
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Group group = this._groupLocalService.getCompanyGroup(companyId);
        serviceContext.setScopeGroupId(group.getGroupId());
        long guestUserId = this._userLocalService.getGuestUserId(companyId);
        serviceContext.setUserId(guestUserId);
        if (!this._ddmStructureLocalService.hasStructure(group.getGroupId(), this._portal.getClassNameId(RawMetadataProcessor.class), name)) {
            Locale locale = this._portal.getSiteDefaultLocale(group.getGroupId());
            HashMap nameMap = HashMapBuilder.put((Object)locale, (Object)name).build();
            HashMap descriptionMap = HashMapBuilder.put((Object)locale, (Object)name).build();
            DDMForm ddmForm = DDMFormUtil.buildDDMForm(RawMetadataProcessorUtil.getFieldNames(), locale);
            DDMFormLayout ddmFormLayout = this._ddm.getDefaultDDMFormLayout(ddmForm);
            this._ddmStructureLocalService.addStructure(null, guestUserId, group.getGroupId(), 0L, this._portal.getClassNameId(RawMetadataProcessor.class), name, (Map)nameMap, (Map)descriptionMap, ddmForm, ddmFormLayout, StorageType.DEFAULT.toString(), 0, serviceContext);
        }
    }
}

