/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.util;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.configuration.DLFileEntryMimeTypeConfiguration;
import com.liferay.document.library.internal.configuration.helper.DLSizeLimitConfigurationHelper;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileMimeTypeException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.document.library.kernel.exception.FolderNameException;
import com.liferay.document.library.kernel.exception.InvalidFileVersionException;
import com.liferay.document.library.kernel.exception.SourceFileNameException;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.upload.configuration.UploadServletRequestConfigurationProvider;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.webdav.DLWebDAVUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, service={DLValidator.class})
public final class DLValidatorImpl
implements DLValidator {
    @Reference
    private ConfigurationProvider _configurationProvider;
    private volatile DLConfiguration _dlConfiguration;
    @Reference
    private DLSizeLimitConfigurationHelper _dlSizeLimitConfigurationHelper;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private UploadServletRequestConfigurationProvider _uploadServletRequestConfigurationProvider;

    public String fixName(String name) {
        if (Validator.isNull((String)name)) {
            return "_";
        }
        for (String blacklistChar : PropsValues.DL_CHAR_BLACKLIST) {
            name = StringUtil.replace((String)name, (String)blacklistChar, (String)"_");
        }
        name = this._replaceDLCharLastBlacklist(name);
        name = this._replaceDLNameBlacklist(name);
        return this._replaceDLWebDAVSubstitutionChar(name);
    }

    public long getMaxAllowableSize(long groupId, String mimeType) {
        return this.getMaxAllowableSize(groupId, mimeType, 0L);
    }

    public long getMaxAllowableSize(long groupId, String mimeType, long limit) {
        long companyId = this._getCompanyId(groupId);
        return this._min(limit, this._min(this._getGlobalMaxAllowableSize(companyId, groupId), this._min(this._dlSizeLimitConfigurationHelper.getCompanyMimeTypeSizeLimit(companyId, mimeType), this._dlSizeLimitConfigurationHelper.getGroupMimeTypeSizeLimit(groupId, mimeType))));
    }

    public Map<String, Long> getMimeTypeSizeLimit(long groupId) {
        HashMap<String, Long> mimeTypeSizeLimit = new HashMap<String, Long>(this._dlSizeLimitConfigurationHelper.getGroupMimeTypeSizeLimit(groupId));
        Map<String, Long> companyMimeTypeSizeLimit = this._dlSizeLimitConfigurationHelper.getCompanyMimeTypeSizeLimit(this._getCompanyId(groupId));
        companyMimeTypeSizeLimit.forEach((key, value) -> mimeTypeSizeLimit.merge((String)key, (Long)value, (value1, value2) -> this._min((long)value1, (long)value2)));
        return mimeTypeSizeLimit;
    }

    public boolean isValidName(String name) {
        if (Validator.isNull((String)name)) {
            return false;
        }
        for (String blacklistChar : PropsValues.DL_CHAR_BLACKLIST) {
            if (!name.contains(blacklistChar)) continue;
            return false;
        }
        for (String blacklistLastChar : PropsValues.DL_CHAR_LAST_BLACKLIST) {
            if (blacklistLastChar.startsWith("\\u")) {
                blacklistLastChar = UnicodeFormatter.parseString((String)blacklistLastChar);
            }
            if (!name.endsWith(blacklistLastChar)) continue;
            return false;
        }
        String nameWithoutExtension = FileUtil.stripExtension((String)name);
        for (String blacklistName : PropsValues.DL_NAME_BLACKLIST) {
            if (!StringUtil.equalsIgnoreCase((String)nameWithoutExtension, (String)blacklistName)) continue;
            return false;
        }
        return true;
    }

    public void validateDirectoryName(String directoryName) throws FolderNameException {
        if (!this.isValidName(directoryName)) {
            throw new FolderNameException("Invalid folder name " + directoryName);
        }
    }

    public void validateFileExtension(String fileName) throws FileExtensionException {
        if (CompanyThreadLocal.isInitializingPortalInstance()) {
            return;
        }
        boolean validFileExtension = false;
        for (String fileExtension : this._dlConfiguration.fileExtensions()) {
            String fileNameExtension = StringUtil.toLowerCase((String)FileUtil.getExtension((String)fileName));
            if (!"*".equals(fileExtension) && !StringUtil.equals((String)fileNameExtension, (String)StringUtil.toLowerCase((String)StringUtil.replace((String)fileExtension, (char)'.', (String)"")))) continue;
            validFileExtension = true;
            break;
        }
        if (!validFileExtension) {
            throw new FileExtensionException.InvalidExtension("Invalid file extension for " + fileName);
        }
    }

    public void validateFileMimeType(long companyId, String mimeType) throws PortalException {
        if (CompanyThreadLocal.isInitializingPortalInstance()) {
            return;
        }
        boolean validFileMimeType = false;
        DLFileEntryMimeTypeConfiguration dlFileEntryMimeTypeConfiguration = (DLFileEntryMimeTypeConfiguration)this._configurationProvider.getCompanyConfiguration(DLFileEntryMimeTypeConfiguration.class, companyId);
        for (String fileMimeType : dlFileEntryMimeTypeConfiguration.fileMimeTypes()) {
            if (!"*".equals(fileMimeType) && !StringUtil.equalsIgnoreCase((String)mimeType, (String)fileMimeType)) continue;
            validFileMimeType = true;
            break;
        }
        if (!validFileMimeType) {
            throw new FileMimeTypeException("Invalid file mime type " + mimeType);
        }
    }

    public void validateFileName(String fileName) throws FileNameException {
        if (!this.isValidName(fileName)) {
            throw new FileNameException("Invalid file name " + fileName);
        }
        if (!DLWebDAVUtil.isRepresentableTitle((String)fileName)) {
            throw new FileNameException("Unrepresentable WebDAV title for file name " + fileName);
        }
    }

    public void validateFileSize(long groupId, String fileName, String mimeType, byte[] bytes) throws FileSizeException {
        if (bytes == null) {
            throw new FileSizeException("File size is zero for " + fileName, this.getMaxAllowableSize(groupId, mimeType, 0L));
        }
        this.validateFileSize(groupId, fileName, mimeType, bytes.length);
    }

    public void validateFileSize(long groupId, String fileName, String mimeType, File file) throws FileSizeException {
        if (file == null) {
            throw new FileSizeException("File is null for " + fileName, this.getMaxAllowableSize(groupId, mimeType, 0L));
        }
        this.validateFileSize(groupId, fileName, mimeType, file.length());
    }

    public void validateFileSize(long groupId, String fileName, String mimeType, InputStream inputStream) throws FileSizeException {
        try {
            if (inputStream == null) {
                throw new FileSizeException("Input stream is null for " + fileName, this.getMaxAllowableSize(groupId, mimeType, 0L));
            }
            this.validateFileSize(groupId, fileName, mimeType, inputStream.available());
        }
        catch (IOException ioException) {
            throw new FileSizeException((Throwable)ioException);
        }
    }

    public void validateFileSize(long groupId, String fileName, String mimeType, long size) throws FileSizeException {
        long maxSize = this.getMaxAllowableSize(groupId, mimeType, 0L);
        if (maxSize > 0L && size > maxSize) {
            throw new FileSizeException(StringBundler.concat((Object[])new Object[]{size, " exceeds the maximum permitted size of ", maxSize, " for file ", fileName}), maxSize);
        }
    }

    public void validateSourceFileExtension(String fileExtension, String sourceFileName) throws SourceFileNameException {
        String sourceFileExtension = FileUtil.getExtension((String)sourceFileName);
        if (Validator.isNotNull((String)sourceFileName) && PropsValues.DL_FILE_EXTENSIONS_STRICT_CHECK && !fileExtension.equals(sourceFileExtension)) {
            throw new SourceFileNameException(StringBundler.concat((String[])new String[]{"File extension ", sourceFileExtension, " is invalid for file name ", sourceFileName}));
        }
    }

    public void validateVersionLabel(String versionLabel) throws InvalidFileVersionException {
        if (Validator.isNull((String)versionLabel)) {
            return;
        }
        if (!DLUtil.isValidVersion((String)versionLabel)) {
            throw new InvalidFileVersionException("Invalid version label " + versionLabel);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
    }

    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    protected void setDLConfiguration(DLConfiguration dlConfiguration) {
        this._dlConfiguration = dlConfiguration;
    }

    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    protected void setUploadServletRequestConfigurationHelper(UploadServletRequestConfigurationProvider uploadServletRequestConfigurationProvider) {
        this._uploadServletRequestConfigurationProvider = uploadServletRequestConfigurationProvider;
    }

    private long _getCompanyId(long groupId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return CompanyThreadLocal.getCompanyId();
        }
        return group.getCompanyId();
    }

    private long _getGlobalMaxAllowableSize(long companyId, long groupId) {
        return this._min(this._uploadServletRequestConfigurationProvider.getMaxSize(), this._min(this._dlSizeLimitConfigurationHelper.getCompanyFileMaxSize(companyId), this._dlSizeLimitConfigurationHelper.getGroupFileMaxSize(groupId)));
    }

    private long _min(long a, long b) {
        if (a == 0L) {
            return b;
        }
        if (b == 0L) {
            return a;
        }
        return Math.min(a, b);
    }

    private String _replaceDLCharLastBlacklist(String title) {
        String previousTitle = null;
        while (!title.equals(previousTitle)) {
            previousTitle = title;
            for (String blacklistLastChar : PropsValues.DL_CHAR_LAST_BLACKLIST) {
                if (blacklistLastChar.startsWith("\\u")) {
                    blacklistLastChar = UnicodeFormatter.parseString((String)blacklistLastChar);
                }
                if (!title.endsWith(blacklistLastChar)) continue;
                title = StringUtil.replaceLast((String)title, (String)blacklistLastChar, (String)"");
            }
        }
        return title;
    }

    private String _replaceDLNameBlacklist(String title) {
        String extension = FileUtil.getExtension((String)title);
        String nameWithoutExtension = FileUtil.stripExtension((String)title);
        for (String blacklistName : PropsValues.DL_NAME_BLACKLIST) {
            if (!StringUtil.equalsIgnoreCase((String)nameWithoutExtension, (String)blacklistName)) continue;
            if (Validator.isNull((String)extension)) {
                return nameWithoutExtension + "_";
            }
            return StringBundler.concat((String[])new String[]{nameWithoutExtension, "_", ".", extension});
        }
        return title;
    }

    private String _replaceDLWebDAVSubstitutionChar(String title) {
        return StringUtil.replace((String)title, (String)PropsValues.DL_WEBDAV_SUBSTITUTION_CHAR, (String)"_");
    }
}

