/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.trash;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.capabilities.UnsupportedCapabilityException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.trash.BaseTrashHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class BaseDLTrashHandler
extends BaseTrashHandler {
    public ContainerModel getContainerModel(long containerModelId) throws PortalException {
        if (containerModelId == 0L) {
            return null;
        }
        return this.getDLFolder(containerModelId);
    }

    public String getContainerModelClassName(long classPK) {
        return DLFolder.class.getName();
    }

    public String getContainerModelName() {
        return "folder";
    }

    public List<ContainerModel> getContainerModels(long classPK, long parentContainerModelId, int start, int end) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        List folders = documentRepository.getFolders(parentContainerModelId, false, start, end, null);
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>(folders.size());
        for (Folder folder : folders) {
            containerModels.add((ContainerModel)folder.getModel());
        }
        return containerModels;
    }

    public int getContainerModelsCount(long classPK, long parentContainerModelId) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        return documentRepository.getFoldersCount(parentContainerModelId, false);
    }

    public List<ContainerModel> getParentContainerModels(long classPK) throws PortalException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        ContainerModel containerModel = this.getParentContainerModel(classPK);
        if (containerModel == null) {
            return containerModels;
        }
        containerModels.add(containerModel);
        while (containerModel.getParentContainerModelId() > 0L && (containerModel = this.getContainerModel(containerModel.getParentContainerModelId())) != null) {
            containerModels.add(containerModel);
        }
        return containerModels;
    }

    public String getRootContainerModelName() {
        return "home";
    }

    public String getTrashContainedModelName() {
        return "documents";
    }

    public int getTrashContainedModelsCount(long classPK) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        return documentRepository.getFileEntriesAndFileShortcutsCount(classPK, 8);
    }

    public String getTrashContainerModelName() {
        return "folders";
    }

    public int getTrashContainerModelsCount(long classPK) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        return documentRepository.getFoldersCount(classPK, 8, false);
    }

    public int getTrashModelsCount(long classPK) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        return documentRepository.getFileEntriesAndFileShortcutsCount(classPK, 8);
    }

    public List<TrashedModel> getTrashModelTrashedModels(long classPK, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        return TransformUtil.transform((Collection)documentRepository.getFoldersAndFileEntriesAndFileShortcuts(classPK, 8, false, start, end, orderByComparator), repositoryEntry -> {
            if (repositoryEntry instanceof FileShortcut) {
                FileShortcut fileShortcut = (FileShortcut)repositoryEntry;
                return (DLFileShortcut)fileShortcut.getModel();
            }
            if (repositoryEntry instanceof FileEntry) {
                FileEntry fileEntry = (FileEntry)repositoryEntry;
                return (DLFileEntry)fileEntry.getModel();
            }
            Folder folder = (Folder)repositoryEntry;
            return (DLFolder)folder.getModel();
        });
    }

    protected DLFolder fetchDLFolder(long classPK) throws PortalException {
        Repository repository = RepositoryProviderUtil.getFolderRepository((long)classPK);
        if (!repository.isCapabilityProvided(TrashCapability.class)) {
            return null;
        }
        Folder folder = repository.getFolder(classPK);
        return (DLFolder)folder.getModel();
    }

    protected DLFolder getDLFolder(long classPK) throws PortalException {
        Repository repository = RepositoryProviderUtil.getFolderRepository((long)classPK);
        if (!repository.isCapabilityProvided(TrashCapability.class)) {
            throw new UnsupportedCapabilityException(TrashCapability.class, "Repository " + repository.getRepositoryId());
        }
        Folder folder = repository.getFolder(classPK);
        return (DLFolder)folder.getModel();
    }

    protected abstract DocumentRepository getDocumentRepository(long var1) throws PortalException;
}

