/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.configuration;

import com.liferay.document.library.configuration.DLSizeLimitConfigurationProvider;
import com.liferay.document.library.internal.configuration.DLSizeLimitConfiguration;
import com.liferay.document.library.internal.configuration.helper.DLSizeLimitConfigurationHelper;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import java.util.Dictionary;
import java.util.Map;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLSizeLimitConfigurationProvider.class})
public class DLSizeLimitConfigurationProviderImpl
implements DLSizeLimitConfigurationProvider {
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private DLSizeLimitConfigurationHelper _dlSizeLimitConfigurationHelper;

    public long getCompanyFileMaxSize(long companyId) {
        return this._dlSizeLimitConfigurationHelper.getCompanyFileMaxSize(companyId);
    }

    public long getCompanyMaxSizeToCopy(long companyId) {
        return this._dlSizeLimitConfigurationHelper.getCompanyMaxSizeToCopy(companyId);
    }

    public Map<String, Long> getCompanyMimeTypeSizeLimit(long companyId) {
        return this._dlSizeLimitConfigurationHelper.getCompanyMimeTypeSizeLimit(companyId);
    }

    public long getGroupFileMaxSize(long groupId) {
        return this._dlSizeLimitConfigurationHelper.getGroupFileMaxSize(groupId);
    }

    public long getGroupMaxSizeToCopy(long groupId) {
        return this._dlSizeLimitConfigurationHelper.getGroupMaxSizeToCopy(groupId);
    }

    public Map<String, Long> getGroupMimeTypeSizeLimit(long groupId) {
        return this._dlSizeLimitConfigurationHelper.getGroupMimeTypeSizeLimit(groupId);
    }

    public long getSystemFileMaxSize() {
        return this._dlSizeLimitConfigurationHelper.getSystemFileMaxSize();
    }

    public long getSystemMaxSizeToCopy() {
        return this._dlSizeLimitConfigurationHelper.getSystemMaxSizeToCopy();
    }

    public Map<String, Long> getSystemMimeTypeSizeLimit() {
        return this._dlSizeLimitConfigurationHelper.getSystemMimeTypeSizeLimit();
    }

    public void updateCompanySizeLimit(long companyId, long fileMaxSize, long maxSizeToCopy, Map<String, Long> mimeTypeSizeLimit) throws Exception {
        Dictionary properties = null;
        Configuration configuration = this._getScopedConfiguration(ExtendedObjectClassDefinition.Scope.COMPANY, companyId);
        if (configuration == null) {
            configuration = this._configurationAdmin.createFactoryConfiguration(DLSizeLimitConfiguration.class.getName() + ".scoped", "?");
            properties = HashMapDictionaryBuilder.put((Object)ExtendedObjectClassDefinition.Scope.COMPANY.getPropertyKey(), (Object)companyId).build();
        } else {
            properties = configuration.getProperties();
        }
        this._updateMimeTypeSizeLimitProperty(properties, mimeTypeSizeLimit);
        properties.put("fileMaxSize", fileMaxSize);
        properties.put("maxSizeToCopy", maxSizeToCopy);
        configuration.update(properties);
    }

    public void updateGroupSizeLimit(long groupId, long fileMaxSize, long maxSizeToCopy, Map<String, Long> mimeTypeSizeLimit) throws Exception {
        Dictionary properties = null;
        Configuration configuration = this._getScopedConfiguration(ExtendedObjectClassDefinition.Scope.GROUP, groupId);
        if (configuration == null) {
            configuration = this._configurationAdmin.createFactoryConfiguration(DLSizeLimitConfiguration.class.getName() + ".scoped", "?");
            properties = HashMapDictionaryBuilder.put((Object)ExtendedObjectClassDefinition.Scope.GROUP.getPropertyKey(), (Object)groupId).build();
        } else {
            properties = configuration.getProperties();
        }
        this._updateMimeTypeSizeLimitProperty(properties, mimeTypeSizeLimit);
        properties.put("fileMaxSize", fileMaxSize);
        properties.put("maxSizeToCopy", maxSizeToCopy);
        configuration.update(properties);
    }

    public void updateSystemSizeLimit(long fileMaxSize, long maxSizeToCopy, Map<String, Long> mimeTypeSizeLimit) throws Exception {
        Configuration configuration = this._configurationAdmin.getConfiguration(DLSizeLimitConfiguration.class.getName(), "?");
        Dictionary properties = configuration.getProperties();
        if (properties == null) {
            properties = new HashMapDictionary();
        }
        this._updateMimeTypeSizeLimitProperty(properties, mimeTypeSizeLimit);
        properties.put("fileMaxSize", fileMaxSize);
        properties.put("maxSizeToCopy", maxSizeToCopy);
        configuration.update(properties);
    }

    private Configuration _getScopedConfiguration(ExtendedObjectClassDefinition.Scope scope, long scopePK) throws Exception {
        Configuration[] configurations = this._configurationAdmin.listConfigurations(String.format("(&(service.factoryPid=%s)(%s=%d))", DLSizeLimitConfiguration.class.getName() + ".scoped", scope.getPropertyKey(), scopePK));
        if (configurations == null) {
            return null;
        }
        return configurations[0];
    }

    private void _updateMimeTypeSizeLimitProperty(Dictionary<String, Object> properties, Map<String, Long> mimeTypeSizeLimit) {
        if (mimeTypeSizeLimit.isEmpty()) {
            properties.put("mimeTypeSizeLimit", new String[0]);
        } else {
            String[] mimeTypeSizeLimitArray = new String[mimeTypeSizeLimit.size()];
            int i = 0;
            for (Map.Entry<String, Long> entry : mimeTypeSizeLimit.entrySet()) {
                mimeTypeSizeLimitArray[i] = entry.getKey() + ":" + entry.getValue();
                ++i;
            }
            properties.put("mimeTypeSizeLimit", mimeTypeSizeLimitArray);
        }
    }
}

