/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.upgrade.v3_2_5;

import com.liferay.document.library.internal.util.DLFileEntryTypePermissionUtil;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.List;

public class DLFileEntryTypesDDMStructureUpgradeProcess
extends UpgradeProcess {
    private final DDMPermissionSupport _ddmPermissionSupport;
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;

    public DLFileEntryTypesDDMStructureUpgradeProcess(DDMPermissionSupport ddmPermissionSupport, ResourceActionLocalService resourceActionLocalService, ResourcePermissionLocalService resourcePermissionLocalService) {
        this._ddmPermissionSupport = ddmPermissionSupport;
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
    }

    protected void doUpgrade() throws Exception {
        String dlFileEntryMetadataResourceName = this._ddmPermissionSupport.getStructureModelResourceName(DLFileEntryMetadata.class.getName());
        List dlFileEntryMetadataResourceAction = this._resourceActionLocalService.getResourceActions(dlFileEntryMetadataResourceName);
        HashSet<String> dlFileEntryMetadataActionIds = new HashSet<String>();
        for (ResourceAction resourceAction : dlFileEntryMetadataResourceAction) {
            dlFileEntryMetadataActionIds.add(resourceAction.getActionId());
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select companyId, fileEntryTypeId, dataDefinitionId from DLFileEntryType");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                long fileEntryTypeId = resultSet.getLong("fileEntryTypeId");
                long dataDefinitionId = resultSet.getLong("dataDefinitionId");
                List resourcePermissions = this._resourcePermissionLocalService.getResourcePermissions(companyId, DLFileEntryType.class.getName(), 4, String.valueOf(fileEntryTypeId));
                this._resourcePermissionLocalService.setResourcePermissions(companyId, dlFileEntryMetadataResourceName, 4, String.valueOf(dataDefinitionId), DLFileEntryTypePermissionUtil.getRoleIdsToActionIds(this._resourceActionLocalService.getResourceActions(DLFileEntryType.class.getName()), resourcePermissions, dlFileEntryMetadataActionIds::contains));
            }
        }
    }
}

